/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tinytree;

import net.sf.saxon.event.Builder;
import net.sf.saxon.event.LocationProvider;
import net.sf.saxon.event.SourceLocationProvider;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.tinytree.CompressedWhitespace;
import net.sf.saxon.tinytree.TinyDocumentImpl;
import net.sf.saxon.tinytree.TinyTree;
import net.sf.saxon.trans.XPathException;

public class TinyBuilder
extends Builder {
    public static final int PARENT_POINTER_INTERVAL = 10;
    private TinyTree tree;
    private int currentDepth = 0;
    private int nodeNr = 0;
    private boolean ended = false;
    private int[] sizeParameters;
    private int[] prevAtDepth = new int[100];
    private int[] siblingsAtDepth = new int[100];
    private boolean isIDElement = false;

    public void setSizeParameters(int[] params) {
        this.sizeParameters = params;
    }

    public int[] getSizeParameters() {
        return new int[]{this.tree.numberOfNodes, this.tree.numberOfAttributes, this.tree.numberOfNamespaces, this.tree.getCharacterBuffer().length()};
    }

    public TinyTree getTree() {
        return this.tree;
    }

    public void open() throws XPathException {
        if (this.started) {
            return;
        }
        if (this.tree == null) {
            this.tree = this.sizeParameters == null ? new TinyTree() : new TinyTree(this.sizeParameters[0], this.sizeParameters[1], this.sizeParameters[2], this.sizeParameters[3]);
            this.tree.setConfiguration(this.config);
            this.currentDepth = 0;
            if (this.lineNumbering) {
                this.tree.setLineNumbering();
            }
        }
        super.open();
    }

    public void startDocument(int properties) throws XPathException {
        int nodeNr;
        if (this.started && !this.ended || this.currentDepth > 0) {
            return;
        }
        this.started = true;
        this.ended = false;
        this.currentRoot = new TinyDocumentImpl(this.tree);
        TinyDocumentImpl doc = (TinyDocumentImpl)this.currentRoot;
        doc.setSystemId(this.getSystemId());
        doc.setBaseURI(this.getBaseURI());
        doc.setConfiguration(this.config);
        this.currentDepth = 0;
        this.prevAtDepth[0] = nodeNr = this.tree.addDocumentNode((TinyDocumentImpl)this.currentRoot);
        this.prevAtDepth[1] = -1;
        this.siblingsAtDepth[0] = 0;
        this.siblingsAtDepth[1] = 0;
        this.tree.next[nodeNr] = -1;
        ++this.currentDepth;
        super.startDocument(0);
    }

    public void endDocument() throws XPathException {
        if (this.currentDepth > 1) {
            return;
        }
        if (this.ended) {
            return;
        }
        this.ended = true;
        this.prevAtDepth[this.currentDepth] = -1;
        --this.currentDepth;
    }

    public void close() throws XPathException {
        this.tree.addNode((short)11, 0, 0, 0, -1);
        this.tree.condense();
        super.close();
    }

    public void startElement(int nameCode, int typeCode, int locationId, int properties) throws XPathException {
        int prev;
        if (this.siblingsAtDepth[this.currentDepth] > 10) {
            this.nodeNr = this.tree.addNode((short)12, this.currentDepth, this.prevAtDepth[this.currentDepth - 1], 0, 0);
            prev = this.prevAtDepth[this.currentDepth];
            if (prev > 0) {
                this.tree.next[prev] = this.nodeNr;
            }
            this.tree.next[this.nodeNr] = this.prevAtDepth[this.currentDepth - 1];
            this.prevAtDepth[this.currentDepth] = this.nodeNr;
            this.siblingsAtDepth[this.currentDepth] = 0;
        }
        this.nodeNr = this.tree.addNode((short)1, this.currentDepth, -1, -1, nameCode);
        boolean bl = this.isIDElement = (properties & 0x800) != 0;
        if (typeCode != 630 && typeCode != -1) {
            if ((properties & 0x10) != 0) {
                typeCode |= 0x20000000;
            }
            this.tree.setElementAnnotation(this.nodeNr, typeCode);
            if (!this.isIDElement && this.config.getTypeHierarchy().isIdCode(typeCode)) {
                this.isIDElement = true;
            }
        }
        if (this.currentDepth == 0) {
            this.prevAtDepth[0] = this.nodeNr;
            this.prevAtDepth[1] = -1;
            this.currentRoot = this.tree.getNode(this.nodeNr);
        } else {
            prev = this.prevAtDepth[this.currentDepth];
            if (prev > 0) {
                this.tree.next[prev] = this.nodeNr;
            }
            this.tree.next[this.nodeNr] = this.prevAtDepth[this.currentDepth - 1];
            this.prevAtDepth[this.currentDepth] = this.nodeNr;
            int n = this.currentDepth;
            this.siblingsAtDepth[n] = this.siblingsAtDepth[n] + 1;
        }
        ++this.currentDepth;
        if (this.currentDepth == this.prevAtDepth.length) {
            int[] p2 = new int[this.currentDepth * 2];
            System.arraycopy(this.prevAtDepth, 0, p2, 0, this.currentDepth);
            this.prevAtDepth = p2;
            p2 = new int[this.currentDepth * 2];
            System.arraycopy(this.siblingsAtDepth, 0, p2, 0, this.currentDepth);
            this.siblingsAtDepth = p2;
        }
        this.prevAtDepth[this.currentDepth] = -1;
        this.siblingsAtDepth[this.currentDepth] = 0;
        LocationProvider locator = this.pipe.getLocationProvider();
        if (locator instanceof SourceLocationProvider) {
            this.tree.setSystemId(this.nodeNr, locator.getSystemId(locationId));
            if (this.lineNumbering) {
                this.tree.setLineNumber(this.nodeNr, locator.getLineNumber(locationId));
            }
        } else if (this.currentDepth == 1) {
            this.tree.setSystemId(this.nodeNr, this.systemId);
        }
        if (this.lineNumbering) {
            this.tree.setLineNumber(this.nodeNr, locator.getLineNumber(locationId));
        }
    }

    public void namespace(int namespaceCode, int properties) throws XPathException {
        this.tree.addNamespace(this.nodeNr, namespaceCode);
    }

    public void attribute(int nameCode, int typeCode, CharSequence value, int locationId, int properties) throws XPathException {
        this.tree.addAttribute(this.currentRoot, this.nodeNr, nameCode, typeCode, value, properties);
    }

    public void startContent() {
        ++this.nodeNr;
    }

    public void endElement() throws XPathException {
        this.prevAtDepth[this.currentDepth] = -1;
        this.siblingsAtDepth[this.currentDepth] = 0;
        --this.currentDepth;
        if (this.isIDElement) {
            this.tree.indexIDElement(this.currentRoot, this.prevAtDepth[this.currentDepth], this.config.getNameChecker());
            this.isIDElement = false;
        }
    }

    public NodeInfo getLastCompletedElement() {
        return this.tree.getNode(this.prevAtDepth[this.currentDepth]);
    }

    public void characters(CharSequence chars, int locationId, int properties) throws XPathException {
        if (chars instanceof CompressedWhitespace && (properties & 0x400) != 0) {
            long lvalue = ((CompressedWhitespace)chars).getCompressedValue();
            this.nodeNr = this.tree.addNode((short)4, this.currentDepth, (int)(lvalue >> 32), (int)lvalue, -1);
            int prev = this.prevAtDepth[this.currentDepth];
            if (prev > 0) {
                this.tree.next[prev] = this.nodeNr;
            }
            this.tree.next[this.nodeNr] = this.prevAtDepth[this.currentDepth - 1];
            this.prevAtDepth[this.currentDepth] = this.nodeNr;
            int n = this.currentDepth;
            this.siblingsAtDepth[n] = this.siblingsAtDepth[n] + 1;
            return;
        }
        int len = chars.length();
        if (len > 0) {
            int bufferStart = this.tree.getCharacterBuffer().length();
            this.tree.appendChars(chars);
            int n = this.tree.numberOfNodes - 1;
            if (this.tree.nodeKind[n] == 3 && this.tree.depth[n] == this.currentDepth) {
                int n2 = n;
                this.tree.beta[n2] = this.tree.beta[n2] + len;
            } else {
                this.nodeNr = this.tree.addNode((short)3, this.currentDepth, bufferStart, len, -1);
                int prev = this.prevAtDepth[this.currentDepth];
                if (prev > 0) {
                    this.tree.next[prev] = this.nodeNr;
                }
                this.tree.next[this.nodeNr] = this.prevAtDepth[this.currentDepth - 1];
                this.prevAtDepth[this.currentDepth] = this.nodeNr;
                int n3 = this.currentDepth;
                this.siblingsAtDepth[n3] = this.siblingsAtDepth[n3] + 1;
            }
        }
    }

    public void processingInstruction(String piname, CharSequence remainder, int locationId, int properties) throws XPathException {
        if (this.tree.commentBuffer == null) {
            this.tree.commentBuffer = new FastStringBuffer(200);
        }
        int s = this.tree.commentBuffer.length();
        this.tree.commentBuffer.append(((Object)remainder).toString());
        int nameCode = this.namePool.allocate("", "", piname);
        this.nodeNr = this.tree.addNode((short)7, this.currentDepth, s, remainder.length(), nameCode);
        int prev = this.prevAtDepth[this.currentDepth];
        if (prev > 0) {
            this.tree.next[prev] = this.nodeNr;
        }
        this.tree.next[this.nodeNr] = this.prevAtDepth[this.currentDepth - 1];
        this.prevAtDepth[this.currentDepth] = this.nodeNr;
        int n = this.currentDepth;
        this.siblingsAtDepth[n] = this.siblingsAtDepth[n] + 1;
        LocationProvider locator = this.pipe.getLocationProvider();
        if (locator instanceof SourceLocationProvider) {
            this.tree.setSystemId(this.nodeNr, locator.getSystemId(locationId));
            if (this.lineNumbering) {
                this.tree.setLineNumber(this.nodeNr, locator.getLineNumber(locationId));
            }
        }
    }

    public void comment(CharSequence chars, int locationId, int properties) throws XPathException {
        if (this.tree.commentBuffer == null) {
            this.tree.commentBuffer = new FastStringBuffer(200);
        }
        int s = this.tree.commentBuffer.length();
        this.tree.commentBuffer.append(((Object)chars).toString());
        this.nodeNr = this.tree.addNode((short)8, this.currentDepth, s, chars.length(), -1);
        int prev = this.prevAtDepth[this.currentDepth];
        if (prev > 0) {
            this.tree.next[prev] = this.nodeNr;
        }
        this.tree.next[this.nodeNr] = this.prevAtDepth[this.currentDepth - 1];
        this.prevAtDepth[this.currentDepth] = this.nodeNr;
        int n = this.currentDepth;
        this.siblingsAtDepth[n] = this.siblingsAtDepth[n] + 1;
    }

    public void setUnparsedEntity(String name, String uri, String publicId) {
        ((TinyDocumentImpl)this.currentRoot).setUnparsedEntity(name, uri, publicId);
    }
}

