'use strict';

export
function formats() {

	return {

		"booleanfalse" : {
			"valid" : {
				"false" : ["Anydata", "偽", ""]
			},
			"invalid" : {},
			"output" : "boolean"
		},
		"booleantrue" : {
			"valid" : {
				"true" : ["Anydata", "真", ""]
			},
			"invalid" : {},
			"output" : "boolean"
		},
		"datedaymonth" : {
			"valid" : {
				"--08-13" : ["13/08", "13.08", "13-08", "13 08", "13\\08",
						"13!08", "13,08", "13 / 08", "13asdf08",
						"13 monkeys landed on the moon in '08"],
				"--08-03" : ["3/8"]
			},
			"invalid" : {
				"" : ["30/02"]
			},
			"output" : "gMonthDay"
		},
		"datedaymonthdk" : {
			"valid" : {
				"--09-25" : ["25. Sep.", "25. sep.", "25. september",
						"25. sepxxxxxx"],
				"--08-13" : ["13. august", "13. AUGUST", "13 AUGUST",
						"13 august", "13. August", "13. Aug", "13. AUG.",
						"13. augustsss"],
				"--09-13" : ["13. SEP", "13. SEPT"],
				"--08-01" : ["1. august", "01. august", "1.august"],
				"--08-22" : ["22. of august"]
			},
			"invalid" : {
				"" : ["13. august 12", "25. september.", "30. februar",
						"1august"]
			},
			"output" : "gMonthDay"
		},
		"datedaymonthen" : {
			"valid" : {
				"--08-13" : ["13 August", "13 Aug", "13 AUGUST", "13 AUG"],
				"--08-22" : ["22nd of August"],
				"--08-01" : ["1ˢᵗ of August", "1 August", "01 August"],
				"--04-30" : ["30th day of January, March and April"]
			},
			"invalid" : {
				"" : ["13 SEPT", "13 Augusts",
						"22nd day of August, which is the sixth month",
						"13 august", "30th February"]
			},
			"output" : "gMonthDay"
		},
		"datedaymonthyear" : {
			"valid" : {
				"2032-08-13" : ["13/08/32", "13.08.32"],
				"2032-08-08" : ["8.8.32"],
				"2003-08-13" : ["13.08.3", "13.08.03"],
				"1998-08-13" : ["13.08.1998"],
				"2032-08-01" : ["01.08.32"],
				"0203-08-13" : ["13.08.0203"],
				"2000-08-13" : ["13.08.00"]
			},
			"invalid" : {
				"" : ["13.08.203", "30.02.09"]
			},
			"output" : "date"
		},
		"datedaymonthyeardk" : {
			"valid" : {
				"2012-09-25" : ["25. Sep. 2012", "25. sep. 2012",
						"25. september 2012", "25. september 12"],
				"2002-09-25" : ["25. september 2"],
				"0203-08-01" : ["1. august 0203"],
				"2000-08-13" : ["13. august 00", "13. august 0"],
				"2012-08-13" : ["13. august 2012", "13. AUGUST 2012",
						"13 AUGUST 2012", "13. August 2012", "13. Aug 2012",
						"13. AUG. 2012", "13. augusts 2012"],
				"2012-09-13" : ["13. SEP 2012", "13. SEPT 2012"],
				"2012-08-01" : ["1. august 2012", "01. august 2012",
						"1 august 2012", "1.august 2012", "1 august2012"],
				"2012-08-22" : ["22. of august 2012"]
			},
			"invalid" : {
				"" : ["1august 2012", "1. august 203", "30. februar 2009",
						"14. okt. １０６６"]
			},
			"output" : "date"
		},
		"datedaymonthyearen" : {
			"valid" : {
				"2009-08-01" : ["01 August 2009", "1 August 2009",
						"1 August 09", "1 August 9", "1 Aug 2009",
						"1st Aug 2009", "1 AUGUST 2009", "1 AUG 2009"],
				"1649-01-30" : ["30th day of January, in the year of our Lord 1649"],
				"1969-04-30" : ["30th day of January, March and April, 1969"],
				"2066-10-14" : ["14 October １０６６ was an inauspicious day, or should I say '66"],
				"0203-08-01" : ["01 August 0203"],
				"2000-08-13" : ["13 August 00", "13 August 0"]
			},
			"invalid" : {
				"" : ["1 aug 2009", "01 August 203", "30 February 2009"]
			},
			"output" : "date"
		},
		"dateerayearmonthdayjp" : {
			"valid" : {
				"1989-05-31" : ["平成元年5月31日", "平成 元 年 5 月 31 日"],
				"2010-05-31" : ["平成22年5月31日", "平22年5月31日", "平 22 年 5 月 31 日",
						"平２２年５月３１日", "平 22 年 5 月 31 日"],
				"2011-05-31" : ["昭和86年5月31日"],
				"2010-05-03" : ["平22年5月03日"],
				"2010-02-13" : ["平22年02月13日"],
				"2020-05-01" : ["平成32年5月1日", "平32年5月1日"],
				"2019-05-01" : ["令和元年5月1日", "令元年5月1日"],
				"2020-05-31" : ["令和2年5月31日", "令2年5月31日"]
			},
			"invalid" : {
				"" : ["創業年22年5月31日", "平成100年5月31日", "平成元年2月30日"]
			},
			"output" : "date"
		},
		"dateerayearmonthjp" : {
			"valid" : {
				"1989-05" : ["平成元年5月"],
				"2010-05" : ["平成22年5月", "平成 22 年 5 月", "平22年5月  ",
						"平 22 年 5 月  ", "平２２年５月", "平 22 年 5 月"],
				"2010-02" : ["平22年02月"],
				"2020-05" : ["平成32年5月", "平32年5月", "令和2年5月", "令2年5月"],
				"2019-05" : ["令和元年5月", "令元年5月"]
			},
			"invalid" : {
				"" : ["創業22年5月", "平成元年13月"]
			},
			"output" : "gYearMonth"
		},
		"datemonthday" : {
			"valid" : {
				"--08-13" : ["08/13", "08.13", "08 / 13"],
				"--08-01" : ["8/1"]
			},
			"invalid" : {
				"" : ["02/30"]
			},
			"output" : "gMonthDay "
		},
		"datemonthdayen" : {
			"valid" : {
				"--08-13" : ["August 13", "Aug 13", "AUGUST 13", "AUG 13",
						"August 13th", "August 13xX"],
				"--08-03" : ["Aug 3", "Aug 03"],
				"--01-30" : ["January, March and April 30"],
				"--09-13" : ["SEPT 13"]
			},
			"invalid" : {
				"" : ["August 1ˢᵗ", "February 30"]
			},
			"output" : "gMonthDay "
		},
		"datemonthdayyear" : {
			"valid" : {
				"2032-08-13" : ["08.13.32", "08/13/32"],
				"2003-08-13" : ["08.13.3"],
				"2032-08-03" : ["8.3.32"],
				"1998-08-13" : ["08.13.1998"],
				"0203-08-13" : ["08.13.0203"],
				"2000-08-13" : ["08.13.00", "08.13.0"]
			},
			"invalid" : {
				"" : ["08.13.203", "02.30.09"]
			},
			"output" : "date"
		},
		"datemonthdayyearen" : {
			"valid" : {
				"2032-08-13" : ["August 13, 2032", "August 13th, 2032",
						"August 13 2032", "Aug 13, 2032"],
				"2032-08-03" : ["Aug 3, 2032", "Aug 03, 2032"],
				"2009-08-13" : ["August 13, 9"],
				"2011-08-13" : ["August 13, 11"],
				"2032-03-13" : ["Martians13x2032"],
				"1969-01-30" : ["January, March and April the 30th, 1969"],
				"0203-08-13" : ["Aug 13 0203"],
				"2000-08-13" : ["August 13 00", "August 13 0"]
			},
			"invalid" : {
				"" : ["Aug 13 203", "February 30th, 2009"]
			},
			"output" : "date"
		},
		"datemonthyeardk" : {
			"valid" : {
				"2012-09" : ["Sep. 2012", "sep. 2012", "september 2012",
						"september 12", "SEP 2012", "SEPT 2012"],
				"2002-09" : ["september 2"],
				"0203-08" : ["august 0203"],
				"2000-08" : ["august 00", "august 0"],
				"2012-08" : ["AUGUST 2012", "August 2012", "Aug 2012",
						"AUG. 2012", "augusts 2012", "august, 2012",
						"august/2012", "august2012"],
				"1969-01" : ["Januar - April, 1969"]
			},
			"invalid" : {
				"" : ["august 203", "okt. １０６６"]
			},
			"output" : "gYearMonth"
		},
		"datemonthyearen" : {
			"valid" : {
				"2032-08" : ["August 2032", "Aug 2032"],
				"2009-08" : ["August 9"],
				"2011-08" : ["August 11"],
				"1969-01" : ["January, March and April, 1969"],
				"2042-03" : ["Marvin the paranoid android detests the number 42"],
				"0203-08" : ["Aug 0203"],
				"2000-08" : ["August 00", "August 0"]
			},
			"invalid" : {
				"" : ["Aug 203"]
			},
			"output" : "gYearMonth"
		},
		"dateyearmonthdaycjk" : {
			"valid" : {
				"2010-05-31" : ["2010年5月31日", "２０１０年５月３１日", "2010 年 5 月 31 日",
						"2010 年 5 月 31 日", "10年5月31日"],
				"2010-12-03" : ["2010年12月3日"],
				"2010-12-31" : ["2010年12月31日"],
				"0203-05-31" : ["0203年5月31日"],
				"2010-05-03" : ["2010年5月03日"],
				"2010-02-13" : ["2010年02月13日"],
				"2001-05-31" : ["1年5月31日"]
			},
			"invalid" : {
				"" : ["203年5月31日", "2010年2月30日"]
			},
			"output" : "date"
		},
		"dateyearmonthen" : {
			"valid" : {
				"2032-08" : ["2032 August", "2032 Aug", "2032 AUG",
						"2032 AUGUST"],
				"1969-04" : ["1969, January, March and April"],
				"2009-08" : ["9 August"],
				"2011-08" : ["11 August"],
				"0203-08" : ["0203 August"],
				"2000-08" : ["00 August", "0 August"]
			},
			"invalid" : {
				"" : ["203 August", "2032 Augusts"]
			},
			"output" : "gYearMonth"
		},
		"dateyearmonthcjk" : {
			"valid" : {
				"2010-05" : ["2010年5月", "２０１０年５月", "2010 年 5 月", "2010 年 5 月",
						"10年5月"],
				"2010-12" : ["2010年12月"],
				"0203-05" : ["0203年5月"],
				"2010-02" : ["2010年02月"],
				"2001-05" : ["1年5月"]
			},
			"invalid" : {
				"" : ["203年5月", "2010年13月"]
			},
			"output" : "gYearMonth"
		},
		"nocontent" : {
			"valid" : {
				"" : ["any string test data", ""]
			},
			"invalid" : {},
			"output" : "nocontentType"
		},
		"numcommadecimal" : {
			"valid" : {
				"123456" : ["123456"],
				"123456789" : ["123 456.789", "123 456 789"],
				"123456.78" : ["123456,78", "123.456,78", "123 456,78",
						"123 456,78"],
				"123456789.012" : ["123.456 789,012"]
			},
			"invalid" : {
				"" : ["-123,45", ",45", "123 456.78", "123,456.78",
						"123E456,78"]
			},
			"output" : "nonNegativeDecimalType"
		},
		"zerodash" : {
			"valid" : {
				"0" : ["-", "֊", "־", "‐", " ", "‒", "–", "—", "―", "﹘", "﹣",
						"－"]
			},
			"invalid" : {
				"" : ["_", "᐀", "᠆", "⸗", "⸚", "〜", "〰", "゠", "︱", "︲"]
			},
			"output" : "zeroIntegerType"
		},
		"numdotdecimal" : {
			"valid" : {
				"123456" : ["123456"],
				"123456789" : ["123 456,789", "123 456 789"],
				"123456.78" : ["123,456.78", "123456.78", "123 456.78",
						"123 456.78"],
				"123456789.012" : ["123,456 789.012"]
			},
			"invalid" : {
				"" : ["123 456,78", "123,45", "-123.45", ".45",
						"123.456 789,012", "123,456E78"]
			},
			"output" : "nonNegativeDecimalType"
		},
		"numunitdecimal" : {
			"valid" : {
				"72.30" : ["72円30銭"],
				"3000.05" : ["3,000円5銭", "３，０００円５銭", "３，０００円 5銭"],
				"3000.50" : ["3,000円50銭", "3,000x50"],
				"3.05" : ["3 dollar 5 cent"],
				"1000.15" : ["１，０００円１５銭"],
				"1000000.15" : ["１，０００，０００円１５銭"],
				"30000.05" : ["30.000 euro 5 cent"],
				"30000.40" : ["30.000 euro 40 cent", "30.000 euro 40"],
				"10.50" : ["10-50", "10/50", "10+50", "10*50", "10^50", "10 50"]
			},
			"invalid" : {
				"" : ["10.50", "10,50", "10．50", "10，50", "10 50.", "10 50,",
						"10 50．", "10 50，", "30E000 euro 40 cent",
						"30.000 euro 500 cent", "30 Euro", "euro 40 cent",
						"-30.000 euro 40 cent"]
			},
			"output" : "nonNegativeDecimalType"
		},
		"dateyearmonthday" : {
			"valid" : {
				"2010-05-31" : ["2010/5/31", "２０１０/５/３１", "2010-5-31",
						"2010.5.31", "2010 5 31", "2010 5 31", "10/5/31"],
				"2010-12-03" : ["2010/12/3"],
				"2010-12-31" : ["2010/12/31"],
				"0203-05-31" : ["0203/5/31"],
				"2010-05-03" : ["2010/5/03"],
				"2010-02-13" : ["2010/02/13"],
				"2001-05-31" : ["1/5/31"]
			},
			"invalid" : {
				"" : ["203/5/31", "2010/2/30"]
			},
			"output" : "date"
		},
		"datemonthyear" : {
			"valid" : {
				"2012-12" : ["12 2012", "12 12", "12/2012", "12.2012"],
				"2012-06" : ["06 2012"],
				"2012-01" : ["1 2012"],
				"2002-12" : ["12 2"],
				"0203-12" : ["12 0203"],
				"2000-12" : ["12 00", "12 0"]
			},
			"invalid" : {
				"" : ["12 201", "13 12"]
			},
			"output" : "gYearMonth"
		},
		"datedaymonthyearin" : {
			"valid" : {
				"2012-09-12" : ["12 सितंबर 2012"],
				"2012-09-06" : ["6 सितंबर 2012", "6 सितंबर 12", "६ सितंबर २०१२"],
				"2012-09-19" : ["१९ सितंबर २०१२", "१९ ०९ २०१२"]
			},
			"invalid" : {
				"" : ["12 सितंबर 201", "६ सितंबर २०१", "31 सितंबर 2012",
						"३१ सितंबर २०१२", "३१ ०९ २०१२", "१९ ०९ २०१",
						"12 09 2012"]
			},
			"output" : "date"
		},
		"datemonthyearin" : {
			"valid" : {
				"2012-09" : ["सितंबर २०१२", "सितंबर 2012"]
			},
			"invalid" : {
				"" : ["सितंबर २०१", "September 2012"]
			},
			"output" : "gYearMonth"
		},
		"calindaymonthyear" : {
			"valid" : {
				"1999-04-01" : ["११ चैत्र १९२१", "११ Chaitra १९२१",
						"११ Caitra १९२१"],
				"1999-05-01" : ["११ वैशाख १९२१", "११ Vaisãkha १९२१",
						"११ Vaisakha १९२१", "११ Vaishakh १९२१",
						"११ Vaiśākha १९२१"],
				"1999-06-01" : ["११ Jyaishta १९२१", "११ Jyaishtha १९२१",
						"११ Jyaistha १९२१", "११ Jyeṣṭha १९२१",
						"११ ज्येष्ठ १९२१"],
				"1999-07-02" : ["११ Asadha १९२१", "११ Asãdha १९२१",
						"११ Ashadha १९२१", "११ Āṣāḍha १९२१"],
				"1999-08-02" : ["११ Sravana १९२१", "११ Srãvana १९२१",
						"११ Shravana १९२१", "११ Śrāvaṇa १९२१", "११ श्रावण १९२१"],
				"1999-09-02" : ["११ Bhadra १९२१", "११ Bhadrapad १९२१",
						"११ Bhādrapada १९२१", "११ Bhādra १९२१",
						"११ Bhãdra १९२१", "११ Proṣṭhapada १९२१",
						"११ भाद्रपद १९२१"],
				"1999-10-03" : ["११ Ashwin १९२१", "११ Aswina १९२१",
						"११ Āśvina १९२१", "११ Asvina १९२१", "११ आश्विन १९२१"],
				"1999-11-02" : ["११ Kartik १९२१", "११ Kārtika १९२१",
						"११ Kãrtika १९२१", "११ Kartika १९२१",
						"११ Kartiak १९२१", "११ कार्तिक १९२१"],
				"1999-12-02" : ["११ Margashirsha १९२१", "११ Mārgaśīrṣa १९२१",
						"११ Agrahayana १९२१", "११ Agrahāyaṇa १९२१",
						"११ मार्गशीर्ष १९२१"],
				"2000-01-01" : ["11 Pausha 1921", "11 पौष 1921",
						"११ Pausha १९२१", "११ Pauṣa १९२१", "११ Pausa १९२१",
						"११ पौष १९२१", "11 Pausa 21"],
				"2099-12-31" : ["10 Pausa 21"],
				"2000-01-31" : ["११ Māgha १९२१", "११ Mãgha १९२१",
						"११ Magh १९२१", "११ Magha १९२१", "११ माघ १९२१"],
				"2000-03-01" : ["११ Phalgun १९२१", "११ Phālguna १९२१",
						"११ Phãlguna १९२१", "११ Phalguna १९२१",
						"११ फाल्गुन १९२१"],
				"2004-03-01" : ["11 Phalguna 1925"],
				"2005-03-01" : ["10 Phalguna 1926"],
				"2005-02-20" : ["1 Phalguna 26"]
			},
			"invalid" : {
				"" : ["11 Pausha 192", "01 January 2000", "31 Pausha 1921"]
			},
			"output" : "date"
		},
		"numdotdecimalin" : {
			"valid" : {
				"123456" : ["123456"],
				"123456789" : ["12 34 56,789"],
				"123456.78" : ["1,23,456.78", "123456.78", "1 23 456.78",
						"1 23 456.78"],
				"123456789.012" : ["12,34,56 789.012"]
			},
			"invalid" : {
				"" : ["1 23 456 789", "123 456,78", "123,45", "-123.45", ".45",
						"12.34 56 789,012", "123,456E78"]
			},
			"output" : "nonNegativeDecimalType"
		},
		"numunitdecimalin" : {
			"valid" : {
				"1234567.08" : ["12,34,567 rupees 8 paise"],
				"123.40" : ["123 rupees 40 paise"],
				"222222333.99" : ["22,22,22,333 Rupees 99 Paise",
						"22,22,22,333 Moo-lah 99 Paise",
						"22,22,22,333 R. 99 P."],
				"12222333.99" : ["1,22,22,333 Rupees 99 Paise"],
				"122333.99" : ["1,22,333 Rupees 99 Paise"],
				"22333.99" : ["22,333 Rupees 99 Paise"],
				"1333.99" : ["1,333 Rupees 99 Paise"],
				"333.99" : ["333 Rupees 99 Paise"],
				"22.99" : ["22 Rupees 99 Paise"],
				"0.99" : ["0 Rupees 99 Paise"],
				"88888888.99" : ["88888888 Rupees 99 Paise"],
				"222222333.00" : ["22,22,22,333 Rupees 0 Paise"],
				"222222333.22" : ["22,22,22,333 Rupees 22 Paise"]
			},
			"invalid" : {
				"" : ["30E000 rupees 40 paise", "30 Rupees", "rupees 40 paise",
						"-30 rupees 40 paise",
						"22,22,22,333 Rupees 4444 Paise",
						"22,22,22,333 Rupees 22,22 Paise",
						"55555,333 Rupees 99 Paise", "0,4444 Rupees 99 Paise",
						"333,333 Rupees 99 Paise", "333,22 Rupees 99 Paise",
						"333,1 Rupees 99 Paise", "22,22 Rupees 99 Paise",
						"1,22 Rupees 99 Paise", "22,1 Rupees 99 Paise"]
			},
			"output" : "nonNegativeDecimalType"
		},

		"datequarterend" : {
			"valid" : {
				"1999-09-30" : ["3rd quarter, 1999", "3rd quarter, 1999"],
				"1999-12-31" : [" Last quarter 1999  ", "Last quarter 1999",
						"1999, Q4"],
				"1999-03-31" : ["1999 1st Quarter"]
			},
			"invalid" : {
				"" : ["1999 5th Quarter"]
			},
			"output" : "date"
		},
		"duryear" : {
			"valid" : {
				"-P22Y4M4D" : ["-22.3456"]
			},
			"invalid" : {},
			"output" : "duration"
		},
		"durmonth" : {
			"valid" : {
				"P22M10D" : ["22.3456"]
			},
			"invalid" : {},
			"output" : "duration"
		},
		"durday" : {
			"valid" : {
				"P0D" : ["0.000001"]
			},
			"invalid" : {},
			"output" : "duration"
		},
		"durhour" : {
			"valid" : {
				"PT1000H" : ["1000"]
			},
			"invalid" : {},
			"output" : "duration"
		},
		"durwordsen" : {
			"valid" : {
				"P5Y2M" : ["Five years, two months"],
				"P9Y2M" : ["9 years, 2 months"]
			},
			"invalid" : {},
			"output" : "duration"
		},
		"numwordsen" : {
			"valid" : {
				"0" : ["no", "None", "zero", "nil"],
				"2" : ["two"],
				"3" : ["three"],
				"8" : ["eight"],
				"9" : ["nine"],
				"11" : ["eleven"],
				"13" : ["thirteen"],
				"22" : ["twenty-two", "Twenty-two", "twenty-Two", "Twenty-Two",
						"twenty֊two", "twenty־two", "twenty‐two", "twenty two",
						"twenty‒two", "twenty–two", "twenty—two", "twenty―two",
						"twenty﹘two", "twenty﹣two", "twenty－two", "twenty two"],
				"74" : ["seventy-four"],
				"162" : ["one hundred and sixty-two"],
				"544" : ["five hundred and forty-four"],
				"1944" : ["nineteen hundred forty-four"],
				"2565" : ["two thousand, five hundred and sixty-five"],
				"5858" : ["five thousand, eight hundred and fifty-eight"],
				"29683" : ["twenty-nine thousand, six hundred and eighty-three"],
				"69795" : ["sixty-nine thousand, seven hundred and ninety-five"],
				"70001" : ["Seventy Thousand and one"],
				"347388" : ["three hundred and forty-seven thousand, three hundred and eighty-eight"],
				"842429" : ["eight hundred and forty-two thousand, four hundred and twenty-nine"],
				"1487444" : ["one million, four hundred and eighty-seven thousand, four hundred and forty-four"],
				"3710372" : ["three million, seven hundred and ten thousand, three hundred and seventy-two"],
				"49237928" : ["forty-nine million, two hundred and thirty-seven thousand, nine hundred and twenty-eight"],
				"73765393" : ["seventy-three million, seven hundred and sixty-five thousand, three hundred and ninety-three"],
				"378547788" : ["three hundred and seventy-eight million, five hundred and forty-seven thousand, seven hundred and eighty-eight"],
				"790015702" : ["seven hundred and ninety million, fifteen thousand, seven hundred and two"],
				"1253387183" : ["one billion, two hundred and fifty-three million, three hundred and eighty-seven thousand, one hundred and eighty-three"],
				"2844293204" : ["two billion, eight hundred and forty-four million, two hundred and ninety-three thousand, two hundred and four"],
				"33980201223" : ["thirty-three billion, nine hundred and eighty million, two hundred and one thousand, two hundred and twenty-three"],
				"56984378478" : ["fifty-six billion, nine hundred and eighty-four million, three hundred and seventy-eight thousand, four hundred and seventy-eight"],
				"783191137800" : ["seven hundred and eighty-three billion, one hundred and ninety-one million, one hundred and thirty-seven thousand, eight hundred"],
				"967472108252" : ["nine hundred and sixty-seven billion, four hundred and seventy-two million, one hundred and eight thousand, two hundred and fifty-two"],
				"7248734501143" : ["seven trillion, two hundred and forty-eight billion, seven hundred and thirty-four million, five hundred and one thousand, one hundred and forty-three"],
				"4790187904648" : ["four trillion, seven hundred and ninety billion, one hundred and eighty-seven million, nine hundred and four thousand, six hundred and forty-eight"],
				"88884950865220" : ["eighty-eight trillion, eight hundred and eighty-four billion, nine hundred and fifty million, eight hundred and sixty-five thousand, two hundred and twenty"],
				"63270302238067" : ["sixty-three trillion, two hundred and seventy billion, three hundred and two million, two hundred and thirty-eight thousand and sixty-seven"],
				"900545854370025" : ["nine hundred trillion, five hundred and forty-five billion, eight hundred and fifty-four million, three hundred and seventy thousand and twenty-five"],
				"126405696784740" : ["one hundred and twenty-six trillion, four hundred and five billion, six hundred and ninety-six million, seven hundred and eighty-four thousand, seven hundred and forty"],
				"8564049305143276" : ["eight quadrillion, five hundred and sixty-four trillion, forty-nine billion, three hundred and five million, one hundred and forty-three thousand, two hundred and seventy-six"],
				"8938709482228958" : ["eight quadrillion, nine hundred and thirty-eight trillion, seven hundred and nine billion, four hundred and eighty-two million, two hundred and twenty-eight thousand, nine hundred and fifty-eight"],
				"25256712407320417" : ["twenty-five quadrillion, two hundred and fifty-six trillion, seven hundred and twelve billion, four hundred and seven million, three hundred and twenty thousand, four hundred and seventeen"],
				"64084946631499633" : ["sixty-four quadrillion, eighty-four trillion, nine hundred and forty-six billion, six hundred and thirty-one million, four hundred and ninety-nine thousand, six hundred and thirty-three"],
				"164193832791879501" : ["one hundred and sixty-four quadrillion, one hundred and ninety-three trillion, eight hundred and thirty-two billion, seven hundred and ninety-one million, eight hundred and seventy-nine thousand, five hundred and one"],
				"837510527347679281" : ["eight hundred and thirty-seven quadrillion, five hundred and ten trillion, five hundred and twenty-seven billion, three hundred and forty-seven million, six hundred and seventy-nine thousand, two hundred and eighty-one"],
				"7711437601223050688" : ["seven quintillion, seven hundred and eleven quadrillion, four hundred and thirty-seven trillion, six hundred and one billion, two hundred and twenty-three million, fifty thousand, six hundred and eighty-eight"],
				"7567423474429182354" : ["seven quintillion, five hundred and sixty-seven quadrillion, four hundred and twenty-three trillion, four hundred and seventy-four billion, four hundred and twenty-nine million, one hundred and eighty-two thousand, three hundred and fifty-four"],
				"27206411301652100409" : ["twenty-seven quintillion, two hundred and six quadrillion, four hundred and eleven trillion, three hundred and one billion, six hundred and fifty-two million, one hundred thousand, four hundred and nine"],
				"91701414519924259601" : ["ninety-one quintillion, seven hundred and one quadrillion, four hundred and fourteen trillion, five hundred and nineteen billion, nine hundred and twenty-four million, two hundred and fifty-nine thousand, six hundred and one"],
				"856612908193758980649" : ["eight hundred and fifty-six quintillion, six hundred and twelve quadrillion, nine hundred and eight trillion, one hundred and ninety-three billion, seven hundred and fifty-eight million, nine hundred and eighty thousand, six hundred and forty-nine"],
				"243448842535378056553" : ["two hundred and forty-three quintillion, four hundred and forty-eight quadrillion, eight hundred and forty-two trillion, five hundred and thirty-five billion, three hundred and seventy-eight million, fifty-six thousand, five hundred and fifty-three"]
			},
			"invalid" : {
				"" : [
						"twenteen hundred forty-four",
						"zilch",
						"twenty-two hundred",
						"two millard, eight hundred and forty-four million, two hundred and ninety-three thousand, two hundred and four",
						"eight billard", "one sextillion", "one septillion",
						"one octillion", "one nonillion", "one decillion",
						"one centillion"]
			},
			"output" : "integer"
		},
		"boolballotbox" : {
			"valid" : {
				"false" : ["☐", "  ☐  "],
				"true" : ["☑", "☒"]
			},
			"invalid" : {
				"" : ["☓"]
			},
			"output" : "boolean"
		},
		"countrynameen" : {
			"valid" : {
				"AF" : ["Afghanistan", "afghanistan", " Afghanistan ",
						" afghanistan "],
				"AX" : ["Åland Islands", "Åland Islands", "Aland Islands",
						"aland islands", "aland Islands"],
				"AL" : ["Albania"],
				"DZ" : ["Algeria"],
				"AS" : ["American Samoa"],
				"AD" : ["Andorra"],
				"AO" : ["Angola"],
				"AI" : ["Anguilla"],
				"AQ" : ["Antarctica"],
				"AG" : ["Antigua and Barbuda"],
				"AR" : ["Argentina", "Republic of Argentina"],
				"AM" : ["Armenia"],
				"AW" : ["Aruba"],
				"AU" : ["Australia"],
				"AT" : ["Austria"],
				"AZ" : ["Azerbaijan"],
				"BS" : ["Bahamas"],
				"BH" : ["Bahrain"],
				"BD" : ["Bangladesh"],
				"BB" : ["Barbados"],
				"BY" : ["Belarus"],
				"BE" : ["Belgium"],
				"BZ" : ["Belize"],
				"BJ" : ["Benin"],
				"BM" : ["Bermuda"],
				"BT" : ["Bhutan"],
				"BO" : ["Bolivia"],
				"BQ" : ["Bonaire, Sint Eustatius and Saba"],
				"BA" : ["Bosnia and Herzegovina"],
				"BW" : ["Botswana"],
				"BV" : ["Bouvet Island"],
				"BR" : ["Brazil", "Brasil",
						"The Federative Republic of Brazil",
						"Federative Republic of Brazil"],
				"IO" : ["British Indian Ocean Territory"],
				"BN" : ["Brunei Darussalam"],
				"BG" : ["Bulgaria"],
				"BF" : ["Burkina Faso"],
				"BI" : ["Burundi"],
				"CV" : ["Cabo Verde"],
				"KH" : ["Cambodia"],
				"CM" : ["Cameroon"],
				"CA" : ["Canada"],
				"KY" : ["Cayman Islands"],
				"CF" : ["Central African Republic"],
				"TD" : ["Chad"],
				"CL" : ["Chile"],
				"CN" : ["The People's Republic of China",
						"The People’s Republic of China", "China"],
				"CX" : ["Christmas Island"],
				"CC" : ["Cocos Islands"],
				"CO" : ["Colombia", "Republic of Colombia"],
				"KM" : ["Comoros"],
				"CG" : ["Congo"],
				"CD" : ["Democratic Republic Of The Congo",
						"Democratic Republic of the Congo",
						"Democratic Republic of Congo"],
				"CK" : ["Cook Islands"],
				"CR" : ["Costa Rica"],
				"CI" : ["Côte d'Ivoire", "Cote d'Ivoire"],
				"HR" : ["Croatia"],
				"CU" : ["Cuba"],
				"CW" : ["Curaçao"],
				"CY" : ["Cyprus"],
				"CZ" : ["Czechia"],
				"DK" : ["Denmark", "The Kingdom of Denmark"],
				"DJ" : ["Djibouti"],
				"DM" : ["Dominica"],
				"DO" : ["Dominican Republic"],
				"EC" : ["Ecuador"],
				"EG" : ["Egypt"],
				"SV" : ["El Salvador"],
				"GQ" : ["Equatorial Guinea"],
				"ER" : ["Eritrea"],
				"EE" : ["Estonia"],
				"SZ" : ["Eswatini"],
				"ET" : ["Ethiopia"],
				"FK" : ["Falkland Islands"],
				"FO" : ["Faroe Islands"],
				"FJ" : ["Fiji"],
				"FI" : ["Finland"],
				"FR" : ["France"],
				"GF" : ["French Guiana"],
				"PF" : ["French Polynesia"],
				"TF" : ["French Southern Territories"],
				"GA" : ["Gabon"],
				"GM" : ["Gambia"],
				"GE" : ["Georgia"],
				"DE" : ["Germany"],
				"GH" : ["Ghana"],
				"GI" : ["Gibraltar"],
				"GR" : ["Greece"],
				"GL" : ["Greenland"],
				"GD" : ["Grenada"],
				"GP" : ["Guadeloupe"],
				"GU" : ["Guam"],
				"GT" : ["Guatemala"],
				"GG" : ["Guernsey"],
				"GN" : ["Guinea"],
				"GW" : ["Guinea-Bissau"],
				"GY" : ["Guyana"],
				"HT" : ["Haiti"],
				"HM" : ["Heard Island and McDonald Islands"],
				"VA" : ["Holy See"],
				"HN" : ["Honduras"],
				"HK" : ["Hong Kong"],
				"HU" : ["Hungary"],
				"IS" : ["Iceland"],
				"IN" : ["India"],
				"ID" : ["Indonesia"],
				"IR" : ["Iran"],
				"IQ" : ["Iraq"],
				"IE" : ["Ireland"],
				"IM" : ["Isle of Man"],
				"IL" : ["Israel"],
				"IT" : ["Italy"],
				"JM" : ["Jamaica"],
				"JP" : ["Japan"],
				"JE" : ["Jersey"],
				"JO" : ["Jordan"],
				"KZ" : ["Kazakhstan"],
				"KE" : ["Kenya"],
				"KI" : ["Kiribati"],
				"KP" : ["Democratic People's Republic of Korea",
						"Democratic Peoples Republic of Korea", "North Korea"],
				"KR" : ["Republic of Korea", "South Korea"],
				"KW" : ["Kuwait"],
				"KG" : ["Kyrgyzstan"],
				"LA" : ["Lao People's Democratic Republic",
						"Lao Peoples Democratic Republic"],
				"LV" : ["Latvia"],
				"LB" : ["Lebanon"],
				"LS" : ["Lesotho"],
				"LR" : ["Liberia"],
				"LY" : ["Libya"],
				"LI" : ["Liechtenstein"],
				"LT" : ["Lithuania"],
				"LU" : ["Luxembourg", "The Grand Duchy of Luxembourg",
						"Grand Duchy of Luxembourg", "The Duchy of Luxembourg"],
				"MO" : ["Macao"],
				"MG" : ["Madagascar"],
				"MW" : ["Malawi"],
				"MY" : ["Malaysia"],
				"MV" : ["Maldives"],
				"ML" : ["Mali"],
				"MT" : ["Malta"],
				"MH" : ["Marshall Islands", "The Republic of Marshall Islands",
						"Republic of Marshall Islands",
						"Republic of The Marshall Islands"],
				"MQ" : ["Martinique"],
				"MR" : ["Mauritania"],
				"MU" : ["Mauritius"],
				"YT" : ["Mayotte"],
				"MX" : ["Mexico", "United Mexican States"],
				"FM" : ["Micronesia"],
				"MD" : ["Moldova"],
				"MC" : ["Monaco"],
				"MN" : ["Mongolia"],
				"ME" : ["Montenegro"],
				"MS" : ["Montserrat"],
				"MA" : ["Morocco"],
				"MZ" : ["Mozambique"],
				"MM" : ["Myanmar"],
				"NA" : ["Namibia"],
				"NR" : ["Nauru"],
				"NP" : ["Nepal"],
				"NL" : ["Netherlands"],
				"NC" : ["New Caledonia"],
				"NZ" : ["New Zealand"],
				"NI" : ["Nicaragua"],
				"NE" : ["Niger"],
				"NG" : ["Nigeria"],
				"NU" : ["Niue"],
				"NF" : ["Norfolk Island"],
				"MK" : ["North Macedonia"],
				"MP" : ["Northern Mariana Islands"],
				"NO" : ["Norway"],
				"OM" : ["Oman"],
				"PK" : ["Pakistan"],
				"PW" : ["Palau"],
				"PS" : ["Palestine"],
				"PA" : ["Panama"],
				"PG" : ["Papua New Guinea"],
				"PY" : ["Paraguay"],
				"PE" : ["Peru"],
				"PH" : ["Philippines"],
				"PN" : ["Pitcairn"],
				"PL" : ["Poland"],
				"PT" : ["Portugal"],
				"PR" : ["Puerto Rico"],
				"QA" : ["Qatar"],
				"RE" : ["Réunion", "Reunion"],
				"RO" : ["Romania"],
				"RU" : ["Russian Federation"],
				"RW" : ["Rwanda"],
				"BL" : ["Saint Barthélemy", "Saint Barthelemy"],
				"SH" : ["Saint Helena, Ascension and Tristan da Cunha"],
				"KN" : ["Saint Kitts and Nevis"],
				"LC" : ["Saint Lucia"],
				"MF" : ["Saint Martin"],
				"PM" : ["Saint Pierre and Miquelon"],
				"VC" : ["Saint Vincent and the Grenadines",
						"Saint Vincent and Grenadines", "Saint Vincent"],
				"WS" : ["Samoa"],
				"SM" : ["San Marino"],
				"ST" : ["Sao Tome and Principe"],
				"SA" : ["Saudi Arabia"],
				"SN" : ["Senegal"],
				"RS" : ["Serbia"],
				"SC" : ["Seychelles"],
				"SL" : ["Sierra Leone"],
				"SG" : ["Singapore"],
				"SX" : ["Sint Maarten"],
				"SK" : ["Slovakia"],
				"SI" : ["Slovenia"],
				"SB" : ["Solomon Islands"],
				"SO" : ["Somalia"],
				"ZA" : ["South Africa", "Republic of South Africa"],
				"GS" : ["South Georgia and the South Sandwich Islands",
						"South Georgia and South Sandwich Islands"],
				"SS" : ["South Sudan"],
				"ES" : ["Spain", "España", "Espana", "The Kingdom of Spain"],
				"LK" : ["Sri Lanka"],
				"SD" : ["Sudan"],
				"SR" : ["Suriname"],
				"SJ" : ["Svalbard and Jan Mayen"],
				"SE" : ["Sweden"],
				"CH" : ["Switzerland"],
				"SY" : ["Syrian Arab Republic", "Syria"],
				"TW" : ["Taiwan Province of China", "Taiwan"],
				"TJ" : ["Tajikistan"],
				"TZ" : ["United Republic of Tanzania", "Tanzania"],
				"TH" : ["Thailand"],
				"TL" : ["Timor-Leste"],
				"TG" : ["Togo"],
				"TK" : ["Tokelau"],
				"TO" : ["Tonga"],
				"TT" : ["Trinidad and Tobago"],
				"TN" : ["Tunisia"],
				"TR" : ["Turkey"],
				"TM" : ["Turkmenistan"],
				"TC" : ["Turks and Caicos Islands"],
				"TV" : ["Tuvalu"],
				"UG" : ["Uganda"],
				"UA" : ["Ukraine"],
				"AE" : ["United Arab Emirates"],
				"GB" : ["United Kingdom of Great Britain and Northern Ireland",
						"United Kingdom", "UK", "U.K.", "Great Britain",
						"Britain", "England", "England and Wales"],
				"UM" : ["United States Minor Outlying Islands"],
				"US" : ["United States of America", "United States", "USA",
						"U.S.A."],
				"UY" : ["Uruguay"],
				"UZ" : ["Uzbekistan"],
				"VU" : ["Vanuatu"],
				"VE" : ["Venezuela"],
				"VN" : ["Viet Nam"],
				"VG" : ["British Virgin Islands"],
				"VI" : ["U.S. Virgin Islands", "US Virgin Islands"],
				"WF" : ["Wallis and Futuna"],
				"EH" : ["Western Sahara"],
				"YE" : ["Yemen"],
				"ZM" : ["Zambia"],
				"ZW" : ["Zimbabwe"]
			},
			"invalid" : {
				"" : ["AFGHANISTAN", "Åland"]
			},
			"output" : "token"
		},
		"stateprovnameen" : {
			"valid" : {
				"AL" : ["Alabama", "alabama"],
				"AK" : ["Alaska"],
				"AZ" : ["Arizona"],
				"AR" : ["Arkansas"],
				"CA" : ["California"],
				"CO" : ["Colorado"],
				"CT" : ["Connecticut"],
				"DE" : ["Delaware"],
				"DC" : ["District of Columbia"],
				"FL" : ["Florida"],
				"GA" : ["Georgia"],
				"HI" : ["Hawaii"],
				"ID" : ["Idaho"],
				"IL" : ["Illinois"],
				"IN" : ["Indiana"],
				"IA" : ["Iowa"],
				"KS" : ["Kansas"],
				"KY" : ["Kentucky"],
				"LA" : ["Louisiana"],
				"ME" : ["Maine"],
				"MD" : ["Maryland"],
				"MA" : ["Massachusetts"],
				"MI" : ["Michigan"],
				"MN" : ["Minnesota"],
				"MS" : ["Mississippi"],
				"MO" : ["Missouri"],
				"MT" : ["Montana"],
				"NE" : ["Nebraska"],
				"NV" : ["Nevada"],
				"NH" : ["New Hampshire"],
				"NJ" : ["New Jersey"],
				"NM" : ["New Mexico"],
				"NY" : ["New York"],
				"NC" : ["North Carolina"],
				"ND" : ["North Dakota"],
				"OH" : ["Ohio"],
				"OK" : ["Oklahoma"],
				"OR" : ["Oregon"],
				"PA" : ["Pennsylvania"],
				"RI" : ["Rhode Island"],
				"SC" : ["South Carolina"],
				"SD" : ["South Dakota"],
				"TN" : ["Tennessee"],
				"TX" : ["Texas"],
				"UT" : ["Utah"],
				"VT" : ["Vermont"],
				"VA" : ["Virginia"],
				"WA" : ["Washington"],
				"WV" : ["West Virginia"],
				"WI" : ["Wisconsin"],
				"WY" : ["Wyoming"],
				"AB" : ["Alberta"],
				"BC" : ["British Columbia"],
				"MB" : ["Manitoba"],
				"NB" : ["New Brunswick"],
				"NL" : ["Newfoundland and Labrador"],
				"NT" : ["Northwest Territories"],
				"NS" : ["Nova Scotia"],
				"NU" : ["Nunavut"],
				"ON" : ["Ontario"],
				"PE" : ["Prince Edward Island"],
				"QC" : ["Quebec", "Québec"],
				"SK" : ["Saskatchewan"],
				"YT" : ["Yukon"]
			},
			"invalid" : {
				"" : ["ALABAMA", "Jefferson"]
			},
			"output" : "normalizedString"
		},
		"edgarprovcountryen" : {
			"valid" : {
				"A0" : ["Alberta", "Alberta, Canada", "Alberta Canada"],
				"A1" : ["British Columbia"],
				"A2" : ["Manitoba"],
				"A3" : ["New Brunswick"],
				"A4" : ["Newfoundland and Labrador", "Newfoundland"],
				"A5" : ["Nova Scotia"],
				"A6" : ["Ontario"],
				"A7" : ["Prince Edward Island"],
				"A8" : ["Quebec", "Québec"],
				"A9" : ["Saskatchewan"],
				"B0" : ["Yukon"],
				"B2" : ["Afghanistan", "afghanistan", " Afghanistan ",
						" afghanistan "],
				"Y6" : ["Åland Islands", "Åland Islands", "Aland Islands",
						"aland islands", "aland Islands"],
				"B3" : ["Albania"],
				"B4" : ["Algeria"],
				"B5" : ["American Samoa"],
				"B6" : ["Andorra"],
				"B7" : ["Angola"],
				"1A" : ["Anguilla"],
				"B8" : ["Antarctica"],
				"B9" : ["Antigua and Barbuda"],
				"C1" : ["Argentina", "Republic of Argentina"],
				"1B" : ["Armenia"],
				"1C" : ["Aruba"],
				"C3" : ["Australia"],
				"C4" : ["Austria"],
				"1D" : ["Azerbaijan"],
				"C5" : ["Bahamas"],
				"C6" : ["Bahrain"],
				"C7" : ["Bangladesh"],
				"C8" : ["Barbados"],
				"1F" : ["Belarus"],
				"C9" : ["Belgium"],
				"D1" : ["Belize"],
				"G6" : ["Benin"],
				"D0" : ["Bermuda"],
				"D2" : ["Bhutan"],
				"D3" : ["Bolivia"],
				"1E" : ["Bosnia and Herzegovina"],
				"B1" : ["Botswana"],
				"D4" : ["Bouvet Island"],
				"D5" : ["Brazil", "Federative Republic of Brazil",
						"The Federative Republic of Brazil", "Brasil"],
				"D6" : ["British Indian Ocean Territory"],
				"D9" : ["Brunei Darussalam"],
				"E0" : ["Bulgaria"],
				"X2" : ["Burkina Faso"],
				"E2" : ["Burundi"],
				"E8" : ["Cabo Verde", "Cape Verde"],
				"E3" : ["Cambodia"],
				"E4" : ["Cameroon"],
				"Z4" : ["Canada"],
				"E9" : ["Cayman Islands"],
				"F0" : ["Central African Republic"],
				"F2" : ["Chad"],
				"F3" : ["Chile"],
				"F4" : ["China", "The People's Republic of China",
						"The People’s Republic of China"],
				"F6" : ["Christmas Island"],
				"F7" : ["Cocos Islands"],
				"F8" : ["Colombia", "Republic of Colombia"],
				"F9" : ["Comoros"],
				"G0" : ["Congo"],
				"Y3" : ["Democratic Republic Of The Congo",
						"Democratic Republic of the Congo",
						"Democratic Republic of Congo"],
				"G1" : ["Cook Islands"],
				"G2" : ["Costa Rica"],
				"L7" : ["Côte d'Ivoire", "Cote d'Ivoire"],
				"1M" : ["Croatia"],
				"G3" : ["Cuba"],
				"G4" : ["Cyprus"],
				"2N" : ["Czechia", "Czech Republic"],
				"G7" : ["Denmark", "The Kingdom of Denmark"],
				"1G" : ["Djibouti"],
				"G9" : ["Dominica"],
				"G8" : ["Dominican Republic"],
				"H1" : ["Ecuador"],
				"H2" : ["Egypt"],
				"H3" : ["El Salvador"],
				"H4" : ["Equatorial Guinea"],
				"1J" : ["Eritrea"],
				"1H" : ["Estonia"],
				"H5" : ["Ethiopia"],
				"H7" : ["Falkland Islands"],
				"H6" : ["Faroe Islands"],
				"H8" : ["Fiji"],
				"H9" : ["Finland"],
				"I0" : ["France"],
				"I3" : ["French Guiana"],
				"I4" : ["French Polynesia"],
				"2C" : ["French Southern Territories"],
				"I5" : ["Gabon"],
				"I6" : ["Gambia"],
				"2Q" : ["Georgia"],
				"2M" : ["Germany"],
				"J0" : ["Ghana"],
				"J1" : ["Gibraltar"],
				"J3" : ["Greece"],
				"J4" : ["Greenland"],
				"J5" : ["Grenada"],
				"J6" : ["Guadeloupe"],
				"GU" : ["Guam"],
				"J8" : ["Guatemala"],
				"Y7" : ["Guernsey"],
				"J9" : ["Guinea"],
				"S0" : ["Guinea-Bissau"],
				"K0" : ["Guyana"],
				"K1" : ["Haiti"],
				"K4" : ["Heard Island and McDonald Islands"],
				"X4" : ["Holy See"],
				"K2" : ["Honduras"],
				"K3" : ["Hong Kong"],
				"K5" : ["Hungary"],
				"K6" : ["Iceland"],
				"K7" : ["India"],
				"K8" : ["Indonesia"],
				"K9" : ["Iran"],
				"L0" : ["Iraq"],
				"L2" : ["Ireland"],
				"Y8" : ["Isle of Man"],
				"L3" : ["Israel"],
				"L6" : ["Italy"],
				"L8" : ["Jamaica"],
				"M0" : ["Japan"],
				"Y9" : ["Jersey"],
				"M2" : ["Jordan"],
				"1P" : ["Kazakhstan"],
				"M3" : ["Kenya"],
				"J2" : ["Kiribati"],
				"M4" : ["Democratic People's Republic of Korea",
						"Democratic Peoples Republic of Korea", "North Korea"],
				"M5" : ["Republic of Korea", "South Korea"],
				"M6" : ["Kuwait"],
				"1N" : ["Kyrgyzstan"],
				"M7" : ["Lao People's Democratic Republic",
						"Lao Peoples Democratic Republic"],
				"1R" : ["Latvia"],
				"M8" : ["Lebanon"],
				"M9" : ["Lesotho"],
				"N0" : ["Liberia"],
				"N1" : ["Libya"],
				"N2" : ["Liechtenstein"],
				"1Q" : ["Lithuania"],
				"N4" : ["Luxembourg", "The Grand Duchy of Luxembourg",
						"Grand Duchy of Luxembourg", "The Duchy of Luxembourg"],
				"N5" : ["Macao"],
				"1U" : ["Macedonia", "North Macedonia"],
				"N6" : ["Madagascar"],
				"N7" : ["Malawi"],
				"N8" : ["Malaysia"],
				"N9" : ["Maldives"],
				"O0" : ["Mali"],
				"O1" : ["Malta"],
				"1T" : ["Marshall Islands", "The Republic of Marshall Islands",
						"Republic of Marshall Islands",
						"Republic of The Marshall Islands"],
				"O2" : ["Martinique"],
				"O3" : ["Mauritania"],
				"O4" : ["Mauritius"],
				"2P" : ["Mayotte"],
				"O5" : ["Mexico", "United Mexican States"],
				"1K" : ["Micronesia"],
				"1S" : ["Moldova"],
				"O9" : ["Monaco"],
				"P0" : ["Mongolia"],
				"Z5" : ["Montenegro"],
				"P1" : ["Montserrat"],
				"P2" : ["Morocco"],
				"P3" : ["Mozambique"],
				"E1" : ["Myanmar"],
				"T6" : ["Namibia"],
				"P5" : ["Nauru"],
				"P6" : ["Nepal"],
				"P7" : ["Netherlands"],
				"P8" : ["Netherlands Antilles"],
				"1W" : ["New Caledonia"],
				"Q2" : ["New Zealand"],
				"Q3" : ["Nicaragua"],
				"Q4" : ["Niger"],
				"Q5" : ["Nigeria"],
				"Q6" : ["Niue"],
				"Q7" : ["Norfolk Island"],
				"1V" : ["Northern Mariana Islands"],
				"Q8" : ["Norway"],
				"P4" : ["Oman"],
				"R0" : ["Pakistan"],
				"1Y" : ["Palau"],
				"1X" : ["Palestine"],
				"R1" : ["Panama"],
				"R2" : ["Papua New Guinea"],
				"R4" : ["Paraguay"],
				"R5" : ["Peru"],
				"R6" : ["Philippines"],
				"R8" : ["Pitcairn"],
				"R9" : ["Poland"],
				"S1" : ["Portugal"],
				"PR" : ["Puerto Rico"],
				"S3" : ["Qatar"],
				"S4" : ["Réunion", "Reunion"],
				"S5" : ["Romania"],
				"1Z" : ["Russian Federation"],
				"S6" : ["Rwanda"],
				"Z0" : ["Saint Barthélemy", "Saint Barthelemy"],
				"U8" : ["Saint Helena, Ascension and Tristan da Cunha"],
				"U7" : ["Saint Kitts and Nevis"],
				"U9" : ["Saint Lucia"],
				"Z1" : ["Saint Martin"],
				"V0" : ["Saint Pierre and Miquelon"],
				"V1" : ["Saint Vincent and the Grenadines",
						"Saint Vincent and Grenadines", "Saint Vincent"],
				"Y0" : ["Samoa"],
				"S8" : ["San Marino"],
				"S9" : ["Sao Tome and Principe"],
				"T0" : ["Saudi Arabia"],
				"T1" : ["Senegal"],
				"Z2" : ["Serbia"],
				"T2" : ["Seychelles"],
				"T8" : ["Sierra Leone"],
				"U0" : ["Singapore"],
				"2B" : ["Slovakia"],
				"2A" : ["Slovenia"],
				"D7" : ["Solomon Islands"],
				"U1" : ["Somalia"],
				"T3" : ["South Africa", "Republic of South Africa"],
				"1L" : ["South Georgia and the South Sandwich Islands",
						"South Georgia and South Sandwich Islands"],
				"U3" : ["Spain", "España", "Espana", "The Kingdom of Spain"],
				"F1" : ["Sri Lanka"],
				"V2" : ["Sudan"],
				"V3" : ["Suriname"],
				"L9" : ["Svalbard and Jan Mayen"],
				"V6" : ["Swaziland"],
				"V7" : ["Sweden"],
				"V8" : ["Switzerland"],
				"V9" : ["Syrian Arab Republic", "Syria"],
				"F5" : ["Taiwan Province of China", "Taiwan"],
				"2D" : ["Tajikistan"],
				"W0" : ["United Republic of Tanzania", "Tanzania"],
				"W1" : ["Thailand"],
				"Z3" : ["Timor-Leste"],
				"W2" : ["Togo"],
				"W3" : ["Tokelau"],
				"W4" : ["Tonga"],
				"W5" : ["Trinidad and Tobago"],
				"W6" : ["Tunisia"],
				"W8" : ["Turkey"],
				"2E" : ["Turkmenistan"],
				"W7" : ["Turks and Caicos Islands"],
				"2G" : ["Tuvalu"],
				"W9" : ["Uganda"],
				"2H" : ["Ukraine"],
				"C0" : ["United Arab Emirates"],
				"X0" : ["United Kingdom of Great Britain and Northern Ireland",
						"United Kingdom", "UK", "U.K.", "Great Britain",
						"Britain", "England", "England and Wales"],
				"2J" : ["United States Minor Outlying Islands"],
				"X1" : ["United States of America", "United States", "USA",
						"U.S.A."],
				"X3" : ["Uruguay"],
				"2K" : ["Uzbekistan"],
				"2L" : ["Vanuatu"],
				"X5" : ["Venezuela"],
				"Q1" : ["Viet Nam"],
				"D8" : ["British Virgin Islands", "Virgin Islands, British"],
				"VI" : ["U.S. Virgin Islands", "US Virgin Islands",
						"Virgin Islands, U.S.", "Virgin Islands, US"],
				"X8" : ["Wallis and Futuna"],
				"U5" : ["Western Sahara"],
				"T7" : ["Yemen"],
				"Y4" : ["Zambia"],
				"Y5" : ["Zimbabwe"],
				"XX" : ["Unknown"]
			},
			"invalid" : {
				"" : ["Jefferson", "AFGHANISTAN", "Åland"]
			},
			"output" : "token"
		},
		"exchnameen" : {
			"valid" : {
				"BOX" : ["BOX Exchange LLC", "box exchange llc", "BOX Exchange"],
				"CboeBYX" : ["Cboe BYX Exchange, Inc.",
						"Cboe BYX Exchange, Inc", "Cboe BYX Exchange",
						"Cboe byx Exchange, Inc."],
				"CboeBZX" : ["Cboe BZX Exchange Inc."],
				"C2" : ["Cboe C2 Exchange, Inc."],
				"CboeEDGA" : ["Cboe EDGA Exchange, Inc.",
						"Cboe edga Exchange, Inc."],
				"CboeEDGX" : ["Cboe EDGX exchange"],
				"CBOE" : ["Cboe Exchange, Inc."],
				"CHX" : ["Chicago Stock Exchange, Inc."],
				"IEX" : ["Investors Exchange LLC"],
				"MIAX" : ["Miami International Securities Exchange LLC"],
				"PEARL" : ["MIAX PEARL, LLC"],
				"BX" : ["Nasdaq BX, Inc. "],
				"GEMX" : ["Nasdaq GEMX, LLC"],
				"ISE" : ["Nasdaq ISE, LLC"],
				"MRX" : ["Nasdaq MRX, LLC"],
				"Phlx" : ["Nasdaq PHLX LLC"],
				"NYSE" : ["New York Stock Exchange",
						"New York Stock Exchange LLC",
						"The New York Stock Exchange",
						"The New York Stock Exchange, LLC",
						"The New Yorsk Stock Exchange LLC", "NYSE", "nyse"],
				"NYSEAMER" : ["NYSE American LLC"],
				"NYSEArca" : ["NYSE Arca, Inc."],
				"NYSENAT" : ["NYSE National, Inc."],
				"NASDAQ" : ["The Nasdaq Stock Market LLC",
						"The NASDAQ Stock Market LLC", "NASDAQ", "nasdaq"]
			},
			"invalid" : {
				"" : ["Bernard Madoff Exchange LLC"]
			},
			"output" : "normalizedString"
		},
		"entityfilercategoryen" : {
			"valid" : {
				"Large Accelerated Filer" : ["Large Accelerated Filer",
						"large accelerated filer"],
				"Accelerated Filer" : ["Accelerated Filer", "accelerated filer"],
				"Non-accelerated Filer" : ["Non-Accelerated filer",
						"Non Accelerated filer", "non accelerated filer"]
			},
			"invalid" : {
				"" : ["starfleet filer"]
			},
			"output" : "string"
		},

		"boolballotbox" : {
			"valid" : {
				"false" : ["☐", "  ☐  "],
				"true" : ["☑", "☒"]
			},
			"invalid" : {
				"" : ["☓"]
			},
			"output" : "boolean"
		},
		"yesnoballotbox" : {
			"valid" : {
				"No" : ["☐", "  ☐  "],
				"Yes" : ["☑", "☒"]
			},
			"invalid" : {
				"" : ["☓"]
			},
			"output" : "boolean"
		},
		"countrynameen" : {
			"valid" : {
				"AF" : ["Afghanistan", "afghanistan", " Afghanistan ",
						" afghanistan "],
				"AX" : ["Åland Islands", "Åland Islands", "Aland Islands",
						"aland islands", "aland Islands"],
				"AL" : ["Albania"],
				"DZ" : ["Algeria"],
				"AS" : ["American Samoa"],
				"AD" : ["Andorra"],
				"AO" : ["Angola"],
				"AI" : ["Anguilla"],
				"AQ" : ["Antarctica"],
				"AG" : ["Antigua and Barbuda"],
				"AR" : ["Argentina"],
				"AM" : ["Armenia"],
				"AW" : ["Aruba"],
				"AU" : ["Australia"],
				"AT" : ["Austria"],
				"AZ" : ["Azerbaijan"],
				"BS" : ["Bahamas"],
				"BH" : ["Bahrain"],
				"BD" : ["Bangladesh"],
				"BB" : ["Barbados"],
				"BY" : ["Belarus"],
				"BE" : ["Belgium"],
				"BZ" : ["Belize"],
				"BJ" : ["Benin"],
				"BM" : ["Bermuda"],
				"BT" : ["Bhutan"],
				"BO" : ["Bolivia"],
				"BQ" : ["Bonaire, Sint Eustatius and Saba"],
				"BA" : ["Bosnia and Herzegovina"],
				"BW" : ["Botswana"],
				"BV" : ["Bouvet Island"],
				"BR" : ["Brazil"],
				"IO" : ["British Indian Ocean Territory"],
				"BN" : ["Brunei Darussalam"],
				"BG" : ["Bulgaria"],
				"BF" : ["Burkina Faso"],
				"BI" : ["Burundi"],
				"CV" : ["Cabo Verde"],
				"KH" : ["Cambodia"],
				"CM" : ["Cameroon"],
				"CA" : ["Canada"],
				"KY" : ["Cayman Islands"],
				"CF" : ["Central African Republic"],
				"TD" : ["Chad"],
				"CL" : ["Chile"],
				"CN" : ["China"],
				"CX" : ["Christmas Island"],
				"CC" : ["Cocos Islands"],
				"CO" : ["Colombia"],
				"KM" : ["Comoros"],
				"CG" : ["Congo"],
				"CD" : ["Democratic Republic Of The Congo",
						"Democratic Republic of the Congo",
						"Democratic Republic of Congo"],
				"CK" : ["Cook Islands"],
				"CR" : ["Costa Rica"],
				"CI" : ["Côte d'Ivoire", "Cote d'Ivoire"],
				"HR" : ["Croatia"],
				"CU" : ["Cuba"],
				"CW" : ["Curaçao"],
				"CY" : ["Cyprus"],
				"CZ" : ["Czechia"],
				"DK" : ["Denmark"],
				"DJ" : ["Djibouti"],
				"DM" : ["Dominica"],
				"DO" : ["Dominican Republic"],
				"EC" : ["Ecuador"],
				"EG" : ["Egypt"],
				"SV" : ["El Salvador"],
				"GQ" : ["Equatorial Guinea"],
				"ER" : ["Eritrea"],
				"EE" : ["Estonia"],
				"SZ" : ["Eswatini"],
				"ET" : ["Ethiopia"],
				"FK" : ["Falkland Islands"],
				"FO" : ["Faroe Islands"],
				"FJ" : ["Fiji"],
				"FI" : ["Finland"],
				"FR" : ["France"],
				"GF" : ["French Guiana"],
				"PF" : ["French Polynesia"],
				"TF" : ["French Southern Territories"],
				"GA" : ["Gabon"],
				"GM" : ["Gambia"],
				"GE" : ["Georgia"],
				"DE" : ["Germany"],
				"GH" : ["Ghana"],
				"GI" : ["Gibraltar"],
				"GR" : ["Greece"],
				"GL" : ["Greenland"],
				"GD" : ["Grenada"],
				"GP" : ["Guadeloupe"],
				"GU" : ["Guam"],
				"GT" : ["Guatemala"],
				"GG" : ["Guernsey"],
				"GN" : ["Guinea"],
				"GW" : ["Guinea-Bissau"],
				"GY" : ["Guyana"],
				"HT" : ["Haiti"],
				"HM" : ["Heard Island and McDonald Islands"],
				"VA" : ["Holy See"],
				"HN" : ["Honduras"],
				"HK" : ["Hong Kong"],
				"HU" : ["Hungary"],
				"IS" : ["Iceland"],
				"IN" : ["India"],
				"ID" : ["Indonesia"],
				"IR" : ["Iran"],
				"IQ" : ["Iraq"],
				"IE" : ["Ireland"],
				"IM" : ["Isle of Man"],
				"IL" : ["Israel"],
				"IT" : ["Italy"],
				"JM" : ["Jamaica"],
				"JP" : ["Japan"],
				"JE" : ["Jersey"],
				"JO" : ["Jordan"],
				"KZ" : ["Kazakhstan"],
				"KE" : ["Kenya"],
				"KI" : ["Kiribati"],
				"KP" : ["Democratic People's Republic of Korea",
						"Democratic Peoples Republic of Korea", "North Korea"],
				"KR" : ["Republic of Korea", "South Korea"],
				"KW" : ["Kuwait"],
				"KG" : ["Kyrgyzstan"],
				"LA" : ["Lao People's Democratic Republic",
						"Lao Peoples Democratic Republic"],
				"LV" : ["Latvia"],
				"LB" : ["Lebanon"],
				"LS" : ["Lesotho"],
				"LR" : ["Liberia"],
				"LY" : ["Libya"],
				"LI" : ["Liechtenstein"],
				"LT" : ["Lithuania"],
				"LU" : ["Luxembourg"],
				"MO" : ["Macao"],
				"MG" : ["Madagascar"],
				"MW" : ["Malawi"],
				"MY" : ["Malaysia"],
				"MV" : ["Maldives"],
				"ML" : ["Mali"],
				"MT" : ["Malta"],
				"MH" : ["Marshall Islands"],
				"MQ" : ["Martinique"],
				"MR" : ["Mauritania"],
				"MU" : ["Mauritius"],
				"YT" : ["Mayotte"],
				"MX" : ["Mexico"],
				"FM" : ["Micronesia"],
				"MD" : ["Moldova"],
				"MC" : ["Monaco"],
				"MN" : ["Mongolia"],
				"ME" : ["Montenegro"],
				"MS" : ["Montserrat"],
				"MA" : ["Morocco"],
				"MZ" : ["Mozambique"],
				"MM" : ["Myanmar"],
				"NA" : ["Namibia"],
				"NR" : ["Nauru"],
				"NP" : ["Nepal"],
				"NL" : ["Netherlands"],
				"NC" : ["New Caledonia"],
				"NZ" : ["New Zealand"],
				"NI" : ["Nicaragua"],
				"NE" : ["Niger"],
				"NG" : ["Nigeria"],
				"NU" : ["Niue"],
				"NF" : ["Norfolk Island"],
				"MK" : ["North Macedonia"],
				"MP" : ["Northern Mariana Islands"],
				"NO" : ["Norway"],
				"OM" : ["Oman"],
				"PK" : ["Pakistan"],
				"PW" : ["Palau"],
				"PS" : ["Palestine"],
				"PA" : ["Panama"],
				"PG" : ["Papua New Guinea"],
				"PY" : ["Paraguay"],
				"PE" : ["Peru"],
				"PH" : ["Philippines"],
				"PN" : ["Pitcairn"],
				"PL" : ["Poland"],
				"PT" : ["Portugal"],
				"PR" : ["Puerto Rico"],
				"QA" : ["Qatar"],
				"RE" : ["Réunion", "Reunion"],
				"RO" : ["Romania"],
				"RU" : ["Russian Federation"],
				"RW" : ["Rwanda"],
				"BL" : ["Saint Barthélemy", "Saint Barthelemy"],
				"SH" : ["Saint Helena, Ascension and Tristan da Cunha"],
				"KN" : ["Saint Kitts and Nevis"],
				"LC" : ["Saint Lucia"],
				"MF" : ["Saint Martin"],
				"PM" : ["Saint Pierre and Miquelon"],
				"VC" : ["Saint Vincent and the Grenadines",
						"Saint Vincent and Grenadines", "Saint Vincent"],
				"WS" : ["Samoa"],
				"SM" : ["San Marino"],
				"ST" : ["Sao Tome and Principe"],
				"SA" : ["Saudi Arabia"],
				"SN" : ["Senegal"],
				"RS" : ["Serbia"],
				"SC" : ["Seychelles"],
				"SL" : ["Sierra Leone"],
				"SG" : ["Singapore"],
				"SX" : ["Sint Maarten"],
				"SK" : ["Slovakia"],
				"SI" : ["Slovenia"],
				"SB" : ["Solomon Islands"],
				"SO" : ["Somalia"],
				"ZA" : ["South Africa"],
				"GS" : ["South Georgia and the South Sandwich Islands",
						"South Georgia and South Sandwich Islands"],
				"SS" : ["South Sudan"],
				"ES" : ["Spain"],
				"LK" : ["Sri Lanka"],
				"SD" : ["Sudan"],
				"SR" : ["Suriname"],
				"SJ" : ["Svalbard and Jan Mayen"],
				"SE" : ["Sweden"],
				"CH" : ["Switzerland"],
				"SY" : ["Syrian Arab Republic", "Syria"],
				"TW" : ["Taiwan Province of China", "Taiwan"],
				"TJ" : ["Tajikistan"],
				"TZ" : ["United Republic of Tanzania", "Tanzania"],
				"TH" : ["Thailand"],
				"TL" : ["Timor-Leste"],
				"TG" : ["Togo"],
				"TK" : ["Tokelau"],
				"TO" : ["Tonga"],
				"TT" : ["Trinidad and Tobago"],
				"TN" : ["Tunisia"],
				"TR" : ["Turkey"],
				"TM" : ["Turkmenistan"],
				"TC" : ["Turks and Caicos Islands"],
				"TV" : ["Tuvalu"],
				"UG" : ["Uganda"],
				"UA" : ["Ukraine"],
				"AE" : ["United Arab Emirates"],
				"GB" : ["United Kingdom of Great Britain and Northern Ireland",
						"United Kingdom", "UK", "U.K.", "Great Britain",
						"Britain"],
				"UM" : ["United States Minor Outlying Islands"],
				"US" : ["United States of America", "United States", "USA",
						"U.S.A."],
				"UY" : ["Uruguay"],
				"UZ" : ["Uzbekistan"],
				"VU" : ["Vanuatu"],
				"VE" : ["Venezuela"],
				"VN" : ["Viet Nam"],
				"VG" : ["British Virgin Islands"],
				"VI" : ["U.S. Virgin Islands", "US Virgin Islands"],
				"WF" : ["Wallis and Futuna"],
				"EH" : ["Western Sahara"],
				"YE" : ["Yemen"],
				"ZM" : ["Zambia"],
				"ZW" : ["Zimbabwe"]
			},
			"invalid" : {
				"" : ["AFGHANISTAN", "Åland"]
			},
			"output" : "boolean"
		},
		"stateprovnameen" : {
			"valid" : {
				"AL" : ["Alabama", "alabama"],
				"AK" : ["Alaska"],
				"AZ" : ["Arizona"],
				"AR" : ["Arkansas"],
				"CA" : ["California"],
				"CO" : ["Colorado"],
				"CT" : ["Connecticut"],
				"DE" : ["Delaware"],
				"DC" : ["District of Columbia"],
				"FL" : ["Florida"],
				"GA" : ["Georgia"],
				"HI" : ["Hawaii"],
				"ID" : ["Idaho"],
				"IL" : ["Illinois"],
				"IN" : ["Indiana"],
				"IA" : ["Iowa"],
				"KS" : ["Kansas"],
				"KY" : ["Kentucky"],
				"LA" : ["Louisiana"],
				"ME" : ["Maine"],
				"MD" : ["Maryland"],
				"MA" : ["Massachusetts"],
				"MI" : ["Michigan"],
				"MN" : ["Minnesota"],
				"MS" : ["Mississippi"],
				"MO" : ["Missouri"],
				"MT" : ["Montana"],
				"NE" : ["Nebraska"],
				"NV" : ["Nevada"],
				"NH" : ["New Hampshire"],
				"NJ" : ["New Jersey"],
				"NM" : ["New Mexico"],
				"NY" : ["New York"],
				"NC" : ["North Carolina"],
				"ND" : ["North Dakota"],
				"OH" : ["Ohio"],
				"OK" : ["Oklahoma"],
				"OR" : ["Oregon"],
				"PA" : ["Pennsylvania"],
				"RI" : ["Rhode Island"],
				"SC" : ["South Carolina"],
				"SD" : ["South Dakota"],
				"TN" : ["Tennessee"],
				"TX" : ["Texas"],
				"UT" : ["Utah"],
				"VT" : ["Vermont"],
				"VA" : ["Virginia"],
				"WA" : ["Washington"],
				"WV" : ["West Virginia"],
				"WI" : ["Wisconsin"],
				"WY" : ["Wyoming"],
				"AB" : ["Alberta"],
				"BC" : ["British Columbia"],
				"MB" : ["Manitoba"],
				"NB" : ["New Brunswick"],
				"NL" : ["Newfoundland and Labrador"],
				"NT" : ["Northwest Territories"],
				"NS" : ["Nova Scotia"],
				"NU" : ["Nunavut"],
				"ON" : ["Ontario"],
				"PE" : ["Prince Edward Island"],
				"QC" : ["Quebec"],
				"SK" : ["Saskatchewan"],
				"YT" : ["Yukon"]
			},
			"invalid" : {
				"" : ["ALABAMA", "Jefferson"]
			},
			"output" : "boolean"
		},
		"exchnameen" : {
			"valid" : {
				"BOX" : ["BOX Exchange LLC", "box exchange llc", "BOX Exchange"],
				"CboeBYX" : ["Cboe BYX Exchange, Inc.",
						"Cboe BYX Exchange, Inc", "Cboe BYX Exchange",
						"Cboe byx Exchange, Inc."],
				"CboeBZX" : ["Cboe BZX Exchange Inc."],
				"C2" : ["Cboe C2 Exchange, Inc."],
				"CboeEDGA" : ["Cboe EDGA Exchange, Inc.",
						"Cboe edga Exchange, Inc."],
				"CboeEDGX" : ["Cboe EDGX exchange"],
				"CBOE" : ["Cboe Exchange, Inc."],
				"CHX" : ["Chicago Stock Exchange, Inc."],
				"IEX" : ["Investors Exchange LLC"],
				"MIAX" : ["Miami International Securities Exchange LLC"],
				"PEARL" : ["MIAX PEARL, LLC"],
				"BX" : ["Nasdaq BX, Inc. "],
				"GEMX" : ["Nasdaq GEMX, LLC"],
				"ISE" : ["Nasdaq ISE, LLC"],
				"MRX" : ["Nasdaq MRX, LLC"],
				"Phlx" : ["Nasdaq PHLX LLC"],
				"NYSE" : ["New York Stock Exchange LLC", "NYSE", "nyse"],
				"NYSEAMER" : ["NYSE American LLC"],
				"NYSEArca" : ["NYSE Arca, Inc."],
				"NYSENAT" : ["NYSE National, Inc."],
				"NASDAQ" : ["The Nasdaq Stock Market LLC", "NASDAQ", "nasdaq"]
			},
			"invalid" : {
				"" : ["Bernard Madoff Exchange LLC"]
			},
			"output" : "boolean"
		},
		"entityfilercategoryen" : {
			"valid" : {
				"Large Accelerated Filer" : ["Large Accelerated Filer",
						"large accelerated filer"],
				"Accelerated Filer" : ["Accelerated Filer", "accelerated filer"],
				"Non-accelerated Filer" : ["Non-Accelerated filer",
						"Non Accelerated filer", "non accelerated filer"]
			},
			"invalid" : {
				"" : ["starfleet filer"]
			},
			"output" : "boolean"
		}

	// "datequarterend" : {
	// "valid" : {
	// "1999-09-30" : ["3rd quarter, 1999", "3rd quarter, 1999"],
	// "1999-12-31" : [" Last quarter 1999 ", "Last quarter 1999",
	// "1999, Q4"],
	// "1999-03-31" : ["1999 1st Quarter"]
	// },
	// "invalid" : {
	// "" : ["1999 5th Quarter"]
	// },
	// "output" : "date"
	// },
	// "duryear" : {
	// "valid" : {
	// "-P22Y4M4D" : ["-22.3456"]
	// },
	// "invalid" : {},
	// "output" : "duration"
	// },
	// "durmonth" : {
	// "valid" : {
	// "P22M10D" : ["22.3456"]
	// },
	// "invalid" : {},
	// "output" : "duration"
	// },
	// "durday" : {
	// "valid" : {
	// "P0D" : ["0.000001"]
	// },
	// "invalid" : {},
	// "output" : "duration"
	// },
	// "durhour" : {
	// "valid" : {
	// "PT1000H" : ["1000"]
	// },
	// "invalid" : {},
	// "output" : "duration"
	// },
	// "durwordsen" : {
	// "valid" : {
	// "P5Y2M" : ["Five years, two months"],
	// "P9Y2M" : ["9 years, 2 months"]
	// },
	// "invalid" : {},
	// "output" : "duration"
	// },
	// "numwordsen" : {
	// "valid" : {
	// "0" : ["no", "None", "zero", "nil"],
	// "2" : ["two"],
	// "3" : ["three"],
	// "8" : ["eight"],
	// "9" : ["nine"],
	// "11" : ["eleven"],
	// "13" : ["thirteen"],
	// "22" : ["twenty-two", "Twenty-two", "twenty-Two", "Twenty-Two",
	// "twenty֊two", "twenty־two", "twenty‐two", "twenty two",
	// "twenty‒two", "twenty–two", "twenty—two", "twenty―two",
	// "twenty﹘two", "twenty﹣two", "twenty－two", "twenty two"],
	// "74" : ["seventy-four"],
	// "162" : ["one hundred and sixty-two"],
	// "544" : ["five hundred and forty-four"],
	// "1944" : ["nineteen hundred forty-four"],
	// "2565" : ["two thousand, five hundred and sixty-five"],
	// "5858" : ["five thousand, eight hundred and fifty-eight"],
	// "29683" : ["twenty-nine thousand, six hundred and eighty-three"],
	// "69795" : ["sixty-nine thousand, seven hundred and ninety-five"],
	// "70001" : ["Seventy Thousand and one"],
	// "347388" : ["three hundred and forty-seven thousand, three hundred and
	// eighty-eight"],
	// "842429" : ["eight hundred and forty-two thousand, four hundred and
	// twenty-nine"],
	// "1487444" : ["one million, four hundred and eighty-seven thousand, four
	// hundred and forty-four"],
	// "3710372" : ["three million, seven hundred and ten thousand, three
	// hundred and seventy-two"],
	// "49237928" : ["forty-nine million, two hundred and thirty-seven thousand,
	// nine hundred and twenty-eight"],
	// "73765393" : ["seventy-three million, seven hundred and sixty-five
	// thousand, three hundred and ninety-three"],
	// "378547788" : ["three hundred and seventy-eight million, five hundred and
	// forty-seven thousand, seven hundred and eighty-eight"],
	// "790015702" : ["seven hundred and ninety million, fifteen thousand, seven
	// hundred and two"],
	// "1253387183" : ["one billion, two hundred and fifty-three million, three
	// hundred and eighty-seven thousand, one hundred and eighty-three"],
	// "2844293204" : ["two billion, eight hundred and forty-four million, two
	// hundred and ninety-three thousand, two hundred and four"],
	// "33980201223" : ["thirty-three billion, nine hundred and eighty million,
	// two hundred and one thousand, two hundred and twenty-three"],
	// "56984378478" : ["fifty-six billion, nine hundred and eighty-four
	// million, three hundred and seventy-eight thousand, four hundred and
	// seventy-eight"],
	// "783191137800" : ["seven hundred and eighty-three billion, one hundred
	// and ninety-one million, one hundred and thirty-seven thousand, eight
	// hundred"],
	// "967472108252" : ["nine hundred and sixty-seven billion, four hundred and
	// seventy-two million, one hundred and eight thousand, two hundred and
	// fifty-two"],
	// "7248734501143" : ["seven trillion, two hundred and forty-eight billion,
	// seven hundred and thirty-four million, five hundred and one thousand, one
	// hundred and forty-three"],
	// "4790187904648" : ["four trillion, seven hundred and ninety billion, one
	// hundred and eighty-seven million, nine hundred and four thousand, six
	// hundred and forty-eight"],
	// "88884950865220" : ["eighty-eight trillion, eight hundred and eighty-four
	// billion, nine hundred and fifty million, eight hundred and sixty-five
	// thousand, two hundred and twenty"],
	// "63270302238067" : ["sixty-three trillion, two hundred and seventy
	// billion, three hundred and two million, two hundred and thirty-eight
	// thousand and sixty-seven"],
	// "900545854370025" : ["nine hundred trillion, five hundred and forty-five
	// billion, eight hundred and fifty-four million, three hundred and seventy
	// thousand and twenty-five"],
	// "126405696784740" : ["one hundred and twenty-six trillion, four hundred
	// and five billion, six hundred and ninety-six million, seven hundred and
	// eighty-four thousand, seven hundred and forty"],
	// "8564049305143276" : ["eight quadrillion, five hundred and sixty-four
	// trillion, forty-nine billion, three hundred and five million, one hundred
	// and forty-three thousand, two hundred and seventy-six"],
	// "8938709482228958" : ["eight quadrillion, nine hundred and thirty-eight
	// trillion, seven hundred and nine billion, four hundred and eighty-two
	// million, two hundred and twenty-eight thousand, nine hundred and
	// fifty-eight"],
	// "25256712407320417" : ["twenty-five quadrillion, two hundred and
	// fifty-six trillion, seven hundred and twelve billion, four hundred and
	// seven million, three hundred and twenty thousand, four hundred and
	// seventeen"],
	// "64084946631499633" : ["sixty-four quadrillion, eighty-four trillion,
	// nine hundred and forty-six billion, six hundred and thirty-one million,
	// four hundred and ninety-nine thousand, six hundred and thirty-three"],
	// "164193832791879501" : ["one hundred and sixty-four quadrillion, one
	// hundred and ninety-three trillion, eight hundred and thirty-two billion,
	// seven hundred and ninety-one million, eight hundred and seventy-nine
	// thousand, five hundred and one"],
	// "837510527347679281" : ["eight hundred and thirty-seven quadrillion, five
	// hundred and ten trillion, five hundred and twenty-seven billion, three
	// hundred and forty-seven million, six hundred and seventy-nine thousand,
	// two hundred and eighty-one"],
	// "7711437601223050688" : ["seven quintillion, seven hundred and eleven
	// quadrillion, four hundred and thirty-seven trillion, six hundred and one
	// billion, two hundred and twenty-three million, fifty thousand, six
	// hundred and eighty-eight"],
	// "7567423474429182354" : ["seven quintillion, five hundred and sixty-seven
	// quadrillion, four hundred and twenty-three trillion, four hundred and
	// seventy-four billion, four hundred and twenty-nine million, one hundred
	// and eighty-two thousand, three hundred and fifty-four"],
	// "27206411301652100409" : ["twenty-seven quintillion, two hundred and six
	// quadrillion, four hundred and eleven trillion, three hundred and one
	// billion, six hundred and fifty-two million, one hundred thousand, four
	// hundred and nine"],
	// "91701414519924259601" : ["ninety-one quintillion, seven hundred and one
	// quadrillion, four hundred and fourteen trillion, five hundred and
	// nineteen billion, nine hundred and twenty-four million, two hundred and
	// fifty-nine thousand, six hundred and one"],
	// "856612908193758980649" : ["eight hundred and fifty-six quintillion, six
	// hundred and twelve quadrillion, nine hundred and eight trillion, one
	// hundred and ninety-three billion, seven hundred and fifty-eight million,
	// nine hundred and eighty thousand, six hundred and forty-nine"],
	// "243448842535378056553" : ["two hundred and forty-three quintillion, four
	// hundred and forty-eight quadrillion, eight hundred and forty-two
	// trillion, five hundred and thirty-five billion, three hundred and
	// seventy-eight million, fifty-six thousand, five hundred and fifty-three"]
	// },
	// "invalid" : {
	// "" : [
	// "twenteen hundred forty-four",
	// "zilch",
	// "twenty-two hundred",
	// "two millard, eight hundred and forty-four million, two hundred and
	// ninety-three thousand, two hundred and four",
	// "eight billard", "one sextillion", "one septillion",
	// "one octillion", "one nonillion", "one decillion",
	// "one centillion"]
	// },
	// "output" : "integer"
	// },
	// "boolballotbox" : {
	// "valid" : {
	// "false" : ["☐", " ☐ "],
	// "true" : ["☑", "☒"]
	// },
	// "invalid" : {
	// "" : ["☓"]
	// },
	// "output" : "boolean"
	// },
	// "countrynameen" : {
	// "valid" : {
	// "AF" : ["Afghanistan", "afghanistan", " Afghanistan ",
	// " afghanistan "],
	// "AX" : ["Åland Islands", "Åland Islands", "Aland Islands",
	// "aland islands", "aland Islands"],
	// "AL" : ["Albania"],
	// "DZ" : ["Algeria"],
	// "AS" : ["American Samoa"],
	// "AD" : ["Andorra"],
	// "AO" : ["Angola"],
	// "AI" : ["Anguilla"],
	// "AQ" : ["Antarctica"],
	// "AG" : ["Antigua and Barbuda"],
	// "AR" : ["Argentina", "Republic of Argentina"],
	// "AM" : ["Armenia"],
	// "AW" : ["Aruba"],
	// "AU" : ["Australia"],
	// "AT" : ["Austria"],
	// "AZ" : ["Azerbaijan"],
	// "BS" : ["Bahamas"],
	// "BH" : ["Bahrain"],
	// "BD" : ["Bangladesh"],
	// "BB" : ["Barbados"],
	// "BY" : ["Belarus"],
	// "BE" : ["Belgium"],
	// "BZ" : ["Belize"],
	// "BJ" : ["Benin"],
	// "BM" : ["Bermuda"],
	// "BT" : ["Bhutan"],
	// "BO" : ["Bolivia"],
	// "BQ" : ["Bonaire, Sint Eustatius and Saba"],
	// "BA" : ["Bosnia and Herzegovina"],
	// "BW" : ["Botswana"],
	// "BV" : ["Bouvet Island"],
	// "BR" : ["Brazil", "Brasil",
	// "The Federative Republic of Brazil",
	// "Federative Republic of Brazil"],
	// "IO" : ["British Indian Ocean Territory"],
	// "BN" : ["Brunei Darussalam"],
	// "BG" : ["Bulgaria"],
	// "BF" : ["Burkina Faso"],
	// "BI" : ["Burundi"],
	// "CV" : ["Cabo Verde"],
	// "KH" : ["Cambodia"],
	// "CM" : ["Cameroon"],
	// "CA" : ["Canada"],
	// "KY" : ["Cayman Islands"],
	// "CF" : ["Central African Republic"],
	// "TD" : ["Chad"],
	// "CL" : ["Chile"],
	// "CN" : ["The People's Republic of China",
	// "The People’s Republic of China", "China"],
	// "CX" : ["Christmas Island"],
	// "CC" : ["Cocos Islands"],
	// "CO" : ["Colombia", "Republic of Colombia"],
	// "KM" : ["Comoros"],
	// "CG" : ["Congo"],
	// "CD" : ["Democratic Republic Of The Congo",
	// "Democratic Republic of the Congo",
	// "Democratic Republic of Congo"],
	// "CK" : ["Cook Islands"],
	// "CR" : ["Costa Rica"],
	// "CI" : ["Côte d'Ivoire", "Cote d'Ivoire"],
	// "HR" : ["Croatia"],
	// "CU" : ["Cuba"],
	// "CW" : ["Curaçao"],
	// "CY" : ["Cyprus"],
	// "CZ" : ["Czechia"],
	// "DK" : ["Denmark", "The Kingdom of Denmark"],
	// "DJ" : ["Djibouti"],
	// "DM" : ["Dominica"],
	// "DO" : ["Dominican Republic"],
	// "EC" : ["Ecuador"],
	// "EG" : ["Egypt"],
	// "SV" : ["El Salvador"],
	// "GQ" : ["Equatorial Guinea"],
	// "ER" : ["Eritrea"],
	// "EE" : ["Estonia"],
	// "SZ" : ["Eswatini"],
	// "ET" : ["Ethiopia"],
	// "FK" : ["Falkland Islands"],
	// "FO" : ["Faroe Islands"],
	// "FJ" : ["Fiji"],
	// "FI" : ["Finland"],
	// "FR" : ["France"],
	// "GF" : ["French Guiana"],
	// "PF" : ["French Polynesia"],
	// "TF" : ["French Southern Territories"],
	// "GA" : ["Gabon"],
	// "GM" : ["Gambia"],
	// "GE" : ["Georgia"],
	// "DE" : ["Germany"],
	// "GH" : ["Ghana"],
	// "GI" : ["Gibraltar"],
	// "GR" : ["Greece"],
	// "GL" : ["Greenland"],
	// "GD" : ["Grenada"],
	// "GP" : ["Guadeloupe"],
	// "GU" : ["Guam"],
	// "GT" : ["Guatemala"],
	// "GG" : ["Guernsey"],
	// "GN" : ["Guinea"],
	// "GW" : ["Guinea-Bissau"],
	// "GY" : ["Guyana"],
	// "HT" : ["Haiti"],
	// "HM" : ["Heard Island and McDonald Islands"],
	// "VA" : ["Holy See"],
	// "HN" : ["Honduras"],
	// "HK" : ["Hong Kong"],
	// "HU" : ["Hungary"],
	// "IS" : ["Iceland"],
	// "IN" : ["India"],
	// "ID" : ["Indonesia"],
	// "IR" : ["Iran"],
	// "IQ" : ["Iraq"],
	// "IE" : ["Ireland"],
	// "IM" : ["Isle of Man"],
	// "IL" : ["Israel"],
	// "IT" : ["Italy"],
	// "JM" : ["Jamaica"],
	// "JP" : ["Japan"],
	// "JE" : ["Jersey"],
	// "JO" : ["Jordan"],
	// "KZ" : ["Kazakhstan"],
	// "KE" : ["Kenya"],
	// "KI" : ["Kiribati"],
	// "KP" : ["Democratic People's Republic of Korea",
	// "Democratic Peoples Republic of Korea", "North Korea"],
	// "KR" : ["Republic of Korea", "South Korea"],
	// "KW" : ["Kuwait"],
	// "KG" : ["Kyrgyzstan"],
	// "LA" : ["Lao People's Democratic Republic",
	// "Lao Peoples Democratic Republic"],
	// "LV" : ["Latvia"],
	// "LB" : ["Lebanon"],
	// "LS" : ["Lesotho"],
	// "LR" : ["Liberia"],
	// "LY" : ["Libya"],
	// "LI" : ["Liechtenstein"],
	// "LT" : ["Lithuania"],
	// "LU" : ["Luxembourg", "The Grand Duchy of Luxembourg",
	// "Grand Duchy of Luxembourg", "The Duchy of Luxembourg"],
	// "MO" : ["Macao"],
	// "MG" : ["Madagascar"],
	// "MW" : ["Malawi"],
	// "MY" : ["Malaysia"],
	// "MV" : ["Maldives"],
	// "ML" : ["Mali"],
	// "MT" : ["Malta"],
	// "MH" : ["Marshall Islands", "The Republic of Marshall Islands",
	// "Republic of Marshall Islands",
	// "Republic of The Marshall Islands"],
	// "MQ" : ["Martinique"],
	// "MR" : ["Mauritania"],
	// "MU" : ["Mauritius"],
	// "YT" : ["Mayotte"],
	// "MX" : ["Mexico", "United Mexican States"],
	// "FM" : ["Micronesia"],
	// "MD" : ["Moldova"],
	// "MC" : ["Monaco"],
	// "MN" : ["Mongolia"],
	// "ME" : ["Montenegro"],
	// "MS" : ["Montserrat"],
	// "MA" : ["Morocco"],
	// "MZ" : ["Mozambique"],
	// "MM" : ["Myanmar"],
	// "NA" : ["Namibia"],
	// "NR" : ["Nauru"],
	// "NP" : ["Nepal"],
	// "NL" : ["Netherlands"],
	// "NC" : ["New Caledonia"],
	// "NZ" : ["New Zealand"],
	// "NI" : ["Nicaragua"],
	// "NE" : ["Niger"],
	// "NG" : ["Nigeria"],
	// "NU" : ["Niue"],
	// "NF" : ["Norfolk Island"],
	// "MK" : ["North Macedonia"],
	// "MP" : ["Northern Mariana Islands"],
	// "NO" : ["Norway"],
	// "OM" : ["Oman"],
	// "PK" : ["Pakistan"],
	// "PW" : ["Palau"],
	// "PS" : ["Palestine"],
	// "PA" : ["Panama"],
	// "PG" : ["Papua New Guinea"],
	// "PY" : ["Paraguay"],
	// "PE" : ["Peru"],
	// "PH" : ["Philippines"],
	// "PN" : ["Pitcairn"],
	// "PL" : ["Poland"],
	// "PT" : ["Portugal"],
	// "PR" : ["Puerto Rico"],
	// "QA" : ["Qatar"],
	// "RE" : ["Réunion", "Reunion"],
	// "RO" : ["Romania"],
	// "RU" : ["Russian Federation"],
	// "RW" : ["Rwanda"],
	// "BL" : ["Saint Barthélemy", "Saint Barthelemy"],
	// "SH" : ["Saint Helena, Ascension and Tristan da Cunha"],
	// "KN" : ["Saint Kitts and Nevis"],
	// "LC" : ["Saint Lucia"],
	// "MF" : ["Saint Martin"],
	// "PM" : ["Saint Pierre and Miquelon"],
	// "VC" : ["Saint Vincent and the Grenadines",
	// "Saint Vincent and Grenadines", "Saint Vincent"],
	// "WS" : ["Samoa"],
	// "SM" : ["San Marino"],
	// "ST" : ["Sao Tome and Principe"],
	// "SA" : ["Saudi Arabia"],
	// "SN" : ["Senegal"],
	// "RS" : ["Serbia"],
	// "SC" : ["Seychelles"],
	// "SL" : ["Sierra Leone"],
	// "SG" : ["Singapore"],
	// "SX" : ["Sint Maarten"],
	// "SK" : ["Slovakia"],
	// "SI" : ["Slovenia"],
	// "SB" : ["Solomon Islands"],
	// "SO" : ["Somalia"],
	// "ZA" : ["South Africa", "Republic of South Africa"],
	// "GS" : ["South Georgia and the South Sandwich Islands",
	// "South Georgia and South Sandwich Islands"],
	// "SS" : ["South Sudan"],
	// "ES" : ["Spain", "España", "Espana", "The Kingdom of Spain"],
	// "LK" : ["Sri Lanka"],
	// "SD" : ["Sudan"],
	// "SR" : ["Suriname"],
	// "SJ" : ["Svalbard and Jan Mayen"],
	// "SE" : ["Sweden"],
	// "CH" : ["Switzerland"],
	// "SY" : ["Syrian Arab Republic", "Syria"],
	// "TW" : ["Taiwan Province of China", "Taiwan"],
	// "TJ" : ["Tajikistan"],
	// "TZ" : ["United Republic of Tanzania", "Tanzania"],
	// "TH" : ["Thailand"],
	// "TL" : ["Timor-Leste"],
	// "TG" : ["Togo"],
	// "TK" : ["Tokelau"],
	// "TO" : ["Tonga"],
	// "TT" : ["Trinidad and Tobago"],
	// "TN" : ["Tunisia"],
	// "TR" : ["Turkey"],
	// "TM" : ["Turkmenistan"],
	// "TC" : ["Turks and Caicos Islands"],
	// "TV" : ["Tuvalu"],
	// "UG" : ["Uganda"],
	// "UA" : ["Ukraine"],
	// "AE" : ["United Arab Emirates"],
	// "GB" : ["United Kingdom of Great Britain and Northern Ireland",
	// "United Kingdom", "UK", "U.K.", "Great Britain",
	// "Britain", "England", "England and Wales"],
	// "UM" : ["United States Minor Outlying Islands"],
	// "US" : ["United States of America", "United States", "USA",
	// "U.S.A."],
	// "UY" : ["Uruguay"],
	// "UZ" : ["Uzbekistan"],
	// "VU" : ["Vanuatu"],
	// "VE" : ["Venezuela"],
	// "VN" : ["Viet Nam"],
	// "VG" : ["British Virgin Islands"],
	// "VI" : ["U.S. Virgin Islands", "US Virgin Islands"],
	// "WF" : ["Wallis and Futuna"],
	// "EH" : ["Western Sahara"],
	// "YE" : ["Yemen"],
	// "ZM" : ["Zambia"],
	// "ZW" : ["Zimbabwe"]
	// },
	// "invalid" : {
	// "" : ["AFGHANISTAN", "Åland"]
	// },
	// "output" : "token"
	// },
	// "stateprovnameen" : {
	// "valid" : {
	// "AL" : ["Alabama", "alabama"],
	// "AK" : ["Alaska"],
	// "AZ" : ["Arizona"],
	// "AR" : ["Arkansas"],
	// "CA" : ["California"],
	// "CO" : ["Colorado"],
	// "CT" : ["Connecticut"],
	// "DE" : ["Delaware"],
	// "DC" : ["District of Columbia"],
	// "FL" : ["Florida"],
	// "GA" : ["Georgia"],
	// "HI" : ["Hawaii"],
	// "ID" : ["Idaho"],
	// "IL" : ["Illinois"],
	// "IN" : ["Indiana"],
	// "IA" : ["Iowa"],
	// "KS" : ["Kansas"],
	// "KY" : ["Kentucky"],
	// "LA" : ["Louisiana"],
	// "ME" : ["Maine"],
	// "MD" : ["Maryland"],
	// "MA" : ["Massachusetts"],
	// "MI" : ["Michigan"],
	// "MN" : ["Minnesota"],
	// "MS" : ["Mississippi"],
	// "MO" : ["Missouri"],
	// "MT" : ["Montana"],
	// "NE" : ["Nebraska"],
	// "NV" : ["Nevada"],
	// "NH" : ["New Hampshire"],
	// "NJ" : ["New Jersey"],
	// "NM" : ["New Mexico"],
	// "NY" : ["New York"],
	// "NC" : ["North Carolina"],
	// "ND" : ["North Dakota"],
	// "OH" : ["Ohio"],
	// "OK" : ["Oklahoma"],
	// "OR" : ["Oregon"],
	// "PA" : ["Pennsylvania"],
	// "RI" : ["Rhode Island"],
	// "SC" : ["South Carolina"],
	// "SD" : ["South Dakota"],
	// "TN" : ["Tennessee"],
	// "TX" : ["Texas"],
	// "UT" : ["Utah"],
	// "VT" : ["Vermont"],
	// "VA" : ["Virginia"],
	// "WA" : ["Washington"],
	// "WV" : ["West Virginia"],
	// "WI" : ["Wisconsin"],
	// "WY" : ["Wyoming"],
	// "AB" : ["Alberta"],
	// "BC" : ["British Columbia"],
	// "MB" : ["Manitoba"],
	// "NB" : ["New Brunswick"],
	// "NL" : ["Newfoundland and Labrador"],
	// "NT" : ["Northwest Territories"],
	// "NS" : ["Nova Scotia"],
	// "NU" : ["Nunavut"],
	// "ON" : ["Ontario"],
	// "PE" : ["Prince Edward Island"],
	// "QC" : ["Quebec", "Québec"],
	// "SK" : ["Saskatchewan"],
	// "YT" : ["Yukon"]
	// },
	// "invalid" : {
	// "" : ["ALABAMA", "Jefferson"]
	// },
	// "output" : "normalizedString"
	// },
	// "edgarprovcountryen" : {
	// "valid" : {
	// "A0" : ["Alberta", "Alberta, Canada", "Alberta Canada"],
	// "A1" : ["British Columbia"],
	// "A2" : ["Manitoba"],
	// "A3" : ["New Brunswick"],
	// "A4" : ["Newfoundland and Labrador", "Newfoundland"],
	// "A5" : ["Nova Scotia"],
	// "A6" : ["Ontario"],
	// "A7" : ["Prince Edward Island"],
	// "A8" : ["Quebec", "Québec"],
	// "A9" : ["Saskatchewan"],
	// "B0" : ["Yukon"],
	// "B2" : ["Afghanistan", "afghanistan", " Afghanistan ",
	// " afghanistan "],
	// "Y6" : ["Åland Islands", "Åland Islands", "Aland Islands",
	// "aland islands", "aland Islands"],
	// "B3" : ["Albania"],
	// "B4" : ["Algeria"],
	// "B5" : ["American Samoa"],
	// "B6" : ["Andorra"],
	// "B7" : ["Angola"],
	// "1A" : ["Anguilla"],
	// "B8" : ["Antarctica"],
	// "B9" : ["Antigua and Barbuda"],
	// "C1" : ["Argentina", "Republic of Argentina"],
	// "1B" : ["Armenia"],
	// "1C" : ["Aruba"],
	// "C3" : ["Australia"],
	// "C4" : ["Austria"],
	// "1D" : ["Azerbaijan"],
	// "C5" : ["Bahamas"],
	// "C6" : ["Bahrain"],
	// "C7" : ["Bangladesh"],
	// "C8" : ["Barbados"],
	// "1F" : ["Belarus"],
	// "C9" : ["Belgium"],
	// "D1" : ["Belize"],
	// "G6" : ["Benin"],
	// "D0" : ["Bermuda"],
	// "D2" : ["Bhutan"],
	// "D3" : ["Bolivia"],
	// "1E" : ["Bosnia and Herzegovina"],
	// "B1" : ["Botswana"],
	// "D4" : ["Bouvet Island"],
	// "D5" : ["Brazil", "Federative Republic of Brazil",
	// "The Federative Republic of Brazil", "Brasil"],
	// "D6" : ["British Indian Ocean Territory"],
	// "D9" : ["Brunei Darussalam"],
	// "E0" : ["Bulgaria"],
	// "X2" : ["Burkina Faso"],
	// "E2" : ["Burundi"],
	// "E8" : ["Cabo Verde", "Cape Verde"],
	// "E3" : ["Cambodia"],
	// "E4" : ["Cameroon"],
	// "Z4" : ["Canada"],
	// "E9" : ["Cayman Islands"],
	// "F0" : ["Central African Republic"],
	// "F2" : ["Chad"],
	// "F3" : ["Chile"],
	// "F4" : ["China", "The People's Republic of China",
	// "The People’s Republic of China"],
	// "F6" : ["Christmas Island"],
	// "F7" : ["Cocos Islands"],
	// "F8" : ["Colombia", "Republic of Colombia"],
	// "F9" : ["Comoros"],
	// "G0" : ["Congo"],
	// "Y3" : ["Democratic Republic Of The Congo",
	// "Democratic Republic of the Congo",
	// "Democratic Republic of Congo"],
	// "G1" : ["Cook Islands"],
	// "G2" : ["Costa Rica"],
	// "L7" : ["Côte d'Ivoire", "Cote d'Ivoire"],
	// "1M" : ["Croatia"],
	// "G3" : ["Cuba"],
	// "G4" : ["Cyprus"],
	// "2N" : ["Czechia", "Czech Republic"],
	// "G7" : ["Denmark", "The Kingdom of Denmark"],
	// "1G" : ["Djibouti"],
	// "G9" : ["Dominica"],
	// "G8" : ["Dominican Republic"],
	// "H1" : ["Ecuador"],
	// "H2" : ["Egypt"],
	// "H3" : ["El Salvador"],
	// "H4" : ["Equatorial Guinea"],
	// "1J" : ["Eritrea"],
	// "1H" : ["Estonia"],
	// "H5" : ["Ethiopia"],
	// "H7" : ["Falkland Islands"],
	// "H6" : ["Faroe Islands"],
	// "H8" : ["Fiji"],
	// "H9" : ["Finland"],
	// "I0" : ["France"],
	// "I3" : ["French Guiana"],
	// "I4" : ["French Polynesia"],
	// "2C" : ["French Southern Territories"],
	// "I5" : ["Gabon"],
	// "I6" : ["Gambia"],
	// "2Q" : ["Georgia"],
	// "2M" : ["Germany"],
	// "J0" : ["Ghana"],
	// "J1" : ["Gibraltar"],
	// "J3" : ["Greece"],
	// "J4" : ["Greenland"],
	// "J5" : ["Grenada"],
	// "J6" : ["Guadeloupe"],
	// "GU" : ["Guam"],
	// "J8" : ["Guatemala"],
	// "Y7" : ["Guernsey"],
	// "J9" : ["Guinea"],
	// "S0" : ["Guinea-Bissau"],
	// "K0" : ["Guyana"],
	// "K1" : ["Haiti"],
	// "K4" : ["Heard Island and McDonald Islands"],
	// "X4" : ["Holy See"],
	// "K2" : ["Honduras"],
	// "K3" : ["Hong Kong"],
	// "K5" : ["Hungary"],
	// "K6" : ["Iceland"],
	// "K7" : ["India"],
	// "K8" : ["Indonesia"],
	// "K9" : ["Iran"],
	// "L0" : ["Iraq"],
	// "L2" : ["Ireland"],
	// "Y8" : ["Isle of Man"],
	// "L3" : ["Israel"],
	// "L6" : ["Italy"],
	// "L8" : ["Jamaica"],
	// "M0" : ["Japan"],
	// "Y9" : ["Jersey"],
	// "M2" : ["Jordan"],
	// "1P" : ["Kazakhstan"],
	// "M3" : ["Kenya"],
	// "J2" : ["Kiribati"],
	// "M4" : ["Democratic People's Republic of Korea",
	// "Democratic Peoples Republic of Korea", "North Korea"],
	// "M5" : ["Republic of Korea", "South Korea"],
	// "M6" : ["Kuwait"],
	// "1N" : ["Kyrgyzstan"],
	// "M7" : ["Lao People's Democratic Republic",
	// "Lao Peoples Democratic Republic"],
	// "1R" : ["Latvia"],
	// "M8" : ["Lebanon"],
	// "M9" : ["Lesotho"],
	// "N0" : ["Liberia"],
	// "N1" : ["Libya"],
	// "N2" : ["Liechtenstein"],
	// "1Q" : ["Lithuania"],
	// "N4" : ["Luxembourg", "The Grand Duchy of Luxembourg",
	// "Grand Duchy of Luxembourg", "The Duchy of Luxembourg"],
	// "N5" : ["Macao"],
	// "1U" : ["Macedonia", "North Macedonia"],
	// "N6" : ["Madagascar"],
	// "N7" : ["Malawi"],
	// "N8" : ["Malaysia"],
	// "N9" : ["Maldives"],
	// "O0" : ["Mali"],
	// "O1" : ["Malta"],
	// "1T" : ["Marshall Islands", "The Republic of Marshall Islands",
	// "Republic of Marshall Islands",
	// "Republic of The Marshall Islands"],
	// "O2" : ["Martinique"],
	// "O3" : ["Mauritania"],
	// "O4" : ["Mauritius"],
	// "2P" : ["Mayotte"],
	// "O5" : ["Mexico", "United Mexican States"],
	// "1K" : ["Micronesia"],
	// "1S" : ["Moldova"],
	// "O9" : ["Monaco"],
	// "P0" : ["Mongolia"],
	// "Z5" : ["Montenegro"],
	// "P1" : ["Montserrat"],
	// "P2" : ["Morocco"],
	// "P3" : ["Mozambique"],
	// "E1" : ["Myanmar"],
	// "T6" : ["Namibia"],
	// "P5" : ["Nauru"],
	// "P6" : ["Nepal"],
	// "P7" : ["Netherlands"],
	// "P8" : ["Netherlands Antilles"],
	// "1W" : ["New Caledonia"],
	// "Q2" : ["New Zealand"],
	// "Q3" : ["Nicaragua"],
	// "Q4" : ["Niger"],
	// "Q5" : ["Nigeria"],
	// "Q6" : ["Niue"],
	// "Q7" : ["Norfolk Island"],
	// "1V" : ["Northern Mariana Islands"],
	// "Q8" : ["Norway"],
	// "P4" : ["Oman"],
	// "R0" : ["Pakistan"],
	// "1Y" : ["Palau"],
	// "1X" : ["Palestine"],
	// "R1" : ["Panama"],
	// "R2" : ["Papua New Guinea"],
	// "R4" : ["Paraguay"],
	// "R5" : ["Peru"],
	// "R6" : ["Philippines"],
	// "R8" : ["Pitcairn"],
	// "R9" : ["Poland"],
	// "S1" : ["Portugal"],
	// "PR" : ["Puerto Rico"],
	// "S3" : ["Qatar"],
	// "S4" : ["Réunion", "Reunion"],
	// "S5" : ["Romania"],
	// "1Z" : ["Russian Federation"],
	// "S6" : ["Rwanda"],
	// "Z0" : ["Saint Barthélemy", "Saint Barthelemy"],
	// "U8" : ["Saint Helena, Ascension and Tristan da Cunha"],
	// "U7" : ["Saint Kitts and Nevis"],
	// "U9" : ["Saint Lucia"],
	// "Z1" : ["Saint Martin"],
	// "V0" : ["Saint Pierre and Miquelon"],
	// "V1" : ["Saint Vincent and the Grenadines",
	// "Saint Vincent and Grenadines", "Saint Vincent"],
	// "Y0" : ["Samoa"],
	// "S8" : ["San Marino"],
	// "S9" : ["Sao Tome and Principe"],
	// "T0" : ["Saudi Arabia"],
	// "T1" : ["Senegal"],
	// "Z2" : ["Serbia"],
	// "T2" : ["Seychelles"],
	// "T8" : ["Sierra Leone"],
	// "U0" : ["Singapore"],
	// "2B" : ["Slovakia"],
	// "2A" : ["Slovenia"],
	// "D7" : ["Solomon Islands"],
	// "U1" : ["Somalia"],
	// "T3" : ["South Africa", "Republic of South Africa"],
	// "1L" : ["South Georgia and the South Sandwich Islands",
	// "South Georgia and South Sandwich Islands"],
	// "U3" : ["Spain", "España", "Espana", "The Kingdom of Spain"],
	// "F1" : ["Sri Lanka"],
	// "V2" : ["Sudan"],
	// "V3" : ["Suriname"],
	// "L9" : ["Svalbard and Jan Mayen"],
	// "V6" : ["Swaziland"],
	// "V7" : ["Sweden"],
	// "V8" : ["Switzerland"],
	// "V9" : ["Syrian Arab Republic", "Syria"],
	// "F5" : ["Taiwan Province of China", "Taiwan"],
	// "2D" : ["Tajikistan"],
	// "W0" : ["United Republic of Tanzania", "Tanzania"],
	// "W1" : ["Thailand"],
	// "Z3" : ["Timor-Leste"],
	// "W2" : ["Togo"],
	// "W3" : ["Tokelau"],
	// "W4" : ["Tonga"],
	// "W5" : ["Trinidad and Tobago"],
	// "W6" : ["Tunisia"],
	// "W8" : ["Turkey"],
	// "2E" : ["Turkmenistan"],
	// "W7" : ["Turks and Caicos Islands"],
	// "2G" : ["Tuvalu"],
	// "W9" : ["Uganda"],
	// "2H" : ["Ukraine"],
	// "C0" : ["United Arab Emirates"],
	// "X0" : ["United Kingdom of Great Britain and Northern Ireland",
	// "United Kingdom", "UK", "U.K.", "Great Britain",
	// "Britain", "England", "England and Wales"],
	// "2J" : ["United States Minor Outlying Islands"],
	// "X1" : ["United States of America", "United States", "USA",
	// "U.S.A."],
	// "X3" : ["Uruguay"],
	// "2K" : ["Uzbekistan"],
	// "2L" : ["Vanuatu"],
	// "X5" : ["Venezuela"],
	// "Q1" : ["Viet Nam"],
	// "D8" : ["British Virgin Islands", "Virgin Islands, British"],
	// "VI" : ["U.S. Virgin Islands", "US Virgin Islands",
	// "Virgin Islands, U.S.", "Virgin Islands, US"],
	// "X8" : ["Wallis and Futuna"],
	// "U5" : ["Western Sahara"],
	// "T7" : ["Yemen"],
	// "Y4" : ["Zambia"],
	// "Y5" : ["Zimbabwe"],
	// "XX" : ["Unknown"]
	// },
	// "invalid" : {
	// "" : ["Jefferson", "AFGHANISTAN", "Åland"]
	// },
	// "output" : "token"
	// },
	// "exchnameen" : {
	// "valid" : {
	// "BOX" : ["BOX Exchange LLC", "box exchange llc", "BOX Exchange"],
	// "CboeBYX" : ["Cboe BYX Exchange, Inc.",
	// "Cboe BYX Exchange, Inc", "Cboe BYX Exchange",
	// "Cboe byx Exchange, Inc."],
	// "CboeBZX" : ["Cboe BZX Exchange Inc."],
	// "C2" : ["Cboe C2 Exchange, Inc."],
	// "CboeEDGA" : ["Cboe EDGA Exchange, Inc.",
	// "Cboe edga Exchange, Inc."],
	// "CboeEDGX" : ["Cboe EDGX exchange"],
	// "CBOE" : ["Cboe Exchange, Inc."],
	// "CHX" : ["Chicago Stock Exchange, Inc."],
	// "IEX" : ["Investors Exchange LLC"],
	// "MIAX" : ["Miami International Securities Exchange LLC"],
	// "PEARL" : ["MIAX PEARL, LLC"],
	// "BX" : ["Nasdaq BX, Inc. "],
	// "GEMX" : ["Nasdaq GEMX, LLC"],
	// "ISE" : ["Nasdaq ISE, LLC"],
	// "MRX" : ["Nasdaq MRX, LLC"],
	// "Phlx" : ["Nasdaq PHLX LLC"],
	// "NYSE" : ["New York Stock Exchange",
	// "New York Stock Exchange LLC",
	// "The New York Stock Exchange",
	// "The New York Stock Exchange, LLC",
	// "The New Yorsk Stock Exchange LLC", "NYSE", "nyse"],
	// "NYSEAMER" : ["NYSE American LLC"],
	// "NYSEArca" : ["NYSE Arca, Inc."],
	// "NYSENAT" : ["NYSE National, Inc."],
	// "NASDAQ" : ["The Nasdaq Stock Market LLC",
	// "The NASDAQ Stock Market LLC", "NASDAQ", "nasdaq"]
	// },
	// "invalid" : {
	// "" : ["Bernard Madoff Exchange LLC"]
	// },
	// "output" : "normalizedString"
	// },
	// "entityfilercategoryen" : {
	// "valid" : {
	// "Large Accelerated Filer" : ["Large Accelerated Filer",
	// "large accelerated filer"],
	// "Accelerated Filer" : ["Accelerated Filer", "accelerated filer"],
	// "Non-accelerated Filer" : ["Non-Accelerated filer",
	// "Non Accelerated filer", "non accelerated filer"]
	// },
	// "invalid" : {
	// "" : ["starfleet filer"]
	// },
	// "output" : "string"
	// }
	};

};