/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.om;

import net.sf.saxon.event.LocationProvider;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.Name11Checker;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.QNameException;
import org.xml.sax.Attributes;

public final class AttributeCollectionImpl
implements Attributes,
AttributeCollection {
    private NamePool namePool;
    private LocationProvider locationProvider;
    private String[] values = null;
    private int[] codes = null;
    private int used = 0;
    public static final AttributeCollection EMPTY_ATTRIBUTE_COLLECTION = new AttributeCollectionImpl(null);
    private static final int RECSIZE = 4;
    private static final int TYPECODE = 1;
    private static final int LOCATIONID = 2;
    private static final int PROPERTIES = 3;

    public AttributeCollectionImpl(NamePool pool) {
        this.namePool = pool;
        this.used = 0;
    }

    public void setLocationProvider(LocationProvider provider) {
        this.locationProvider = provider;
    }

    public void addAttribute(int nameCode, int typeCode, String value, long locationId, int properties) {
        if (this.values == null) {
            this.values = new String[5];
            this.codes = new int[20];
            this.used = 0;
        }
        if (this.values.length == this.used) {
            int newsize = this.used == 0 ? 5 : this.used * 2;
            String[] v2 = new String[newsize];
            int[] c2 = new int[newsize * 4];
            System.arraycopy(this.values, 0, v2, 0, this.used);
            System.arraycopy(this.codes, 0, c2, 0, this.used * 4);
            this.values = v2;
            this.codes = c2;
        }
        int n = this.used * 4;
        this.codes[n] = nameCode;
        this.codes[n + 1] = typeCode;
        this.codes[n + 2] = (int)locationId;
        this.codes[n + 3] = properties;
        this.values[this.used++] = value;
    }

    public void setAttribute(int index, int nameCode, int typeCode, String value, long locationId, int properties) {
        int n = index * 4;
        this.codes[n] = nameCode;
        this.codes[n + 1] = typeCode;
        this.codes[n + 2] = (int)locationId;
        this.codes[n + 3] = properties;
        this.values[index] = value;
    }

    public void clear() {
        this.used = 0;
    }

    public void compact() {
        if (this.used == 0) {
            this.codes = null;
            this.values = null;
        } else if (this.values.length > this.used) {
            String[] v2 = new String[this.used];
            int[] c2 = new int[this.used * 4];
            System.arraycopy(this.values, 0, v2, 0, this.used);
            System.arraycopy(this.codes, 0, c2, 0, this.used * 4);
            this.values = v2;
            this.codes = c2;
        }
    }

    public int getLength() {
        return this.values == null ? 0 : this.used;
    }

    public int getNameCode(int index) {
        if (this.codes == null) {
            return -1;
        }
        if (index < 0 || index >= this.used) {
            return -1;
        }
        return this.codes[index * 4];
    }

    public int getTypeAnnotation(int index) {
        if (this.codes == null) {
            return 631;
        }
        if (index < 0 || index >= this.used) {
            return 631;
        }
        return this.codes[index * 4 + 1];
    }

    public int getLocationId(int index) {
        if (this.codes == null) {
            return -1;
        }
        if (index < 0 || index >= this.used) {
            return -1;
        }
        return this.codes[index * 4 + 2];
    }

    public String getSystemId(int index) {
        return this.locationProvider.getSystemId(this.getLocationId(index));
    }

    public int getLineNumber(int index) {
        return this.locationProvider.getLineNumber(this.getLocationId(index));
    }

    public int getProperties(int index) {
        if (this.codes == null) {
            return -1;
        }
        if (index < 0 || index >= this.used) {
            return -1;
        }
        return this.codes[index * 4 + 3];
    }

    public String getPrefix(int index) {
        if (this.codes == null) {
            return null;
        }
        if (index < 0 || index >= this.used) {
            return null;
        }
        return this.namePool.getPrefix(this.getNameCode(index));
    }

    public String getQName(int index) {
        if (this.codes == null) {
            return null;
        }
        if (index < 0 || index >= this.used) {
            return null;
        }
        return this.namePool.getDisplayName(this.getNameCode(index));
    }

    public String getLocalName(int index) {
        if (this.codes == null) {
            return null;
        }
        if (index < 0 || index >= this.used) {
            return null;
        }
        return this.namePool.getLocalName(this.getNameCode(index));
    }

    public String getURI(int index) {
        if (this.codes == null) {
            return null;
        }
        if (index < 0 || index >= this.used) {
            return null;
        }
        return this.namePool.getURI(this.getNameCode(index));
    }

    public String getType(int index) {
        int typeCode = this.getTypeAnnotation(index) & 0xFFFFF;
        switch (typeCode) {
            case 560: {
                return "ID";
            }
            case 561: {
                return "IDREF";
            }
            case 556: {
                return "NMTOKEN";
            }
            case 563: {
                return "ENTITY";
            }
            case 562: {
                return "IDREFS";
            }
            case 557: {
                return "NMTOKENS";
            }
            case 564: {
                return "ENTITIES";
            }
        }
        return "CDATA";
    }

    public String getType(String uri, String localname) {
        int index = this.findByName(uri, localname);
        return index < 0 ? null : this.getType(index);
    }

    public String getValue(int index) {
        if (this.values == null) {
            return null;
        }
        if (index < 0 || index >= this.used) {
            return null;
        }
        return this.values[index];
    }

    public String getValue(String uri, String localname) {
        int index = this.findByName(uri, localname);
        return index < 0 ? null : this.getValue(index);
    }

    public String getValueByFingerprint(int fingerprint) {
        int index = this.findByFingerprint(fingerprint);
        return index < 0 ? null : this.getValue(index);
    }

    public int getIndex(String qname) {
        String[] parts;
        if (this.codes == null) {
            return -1;
        }
        if (qname.indexOf(58) < 0) {
            return this.findByName("", qname);
        }
        try {
            parts = Name11Checker.getInstance().getQNameParts(qname);
        }
        catch (QNameException err) {
            return -1;
        }
        String prefix = parts[0];
        if (prefix.length() == 0) {
            return this.findByName("", qname);
        }
        String localName = parts[1];
        for (int i = 0; i < this.used; ++i) {
            String lname = this.namePool.getLocalName(this.getNameCode(i));
            String ppref = this.namePool.getPrefix(this.getNameCode(i));
            if (!localName.equals(lname) || !prefix.equals(ppref)) continue;
            return i;
        }
        return -1;
    }

    public int getIndex(String uri, String localname) {
        return this.findByName(uri, localname);
    }

    public int getIndexByFingerprint(int fingerprint) {
        return this.findByFingerprint(fingerprint);
    }

    public String getType(String name) {
        int index = this.getIndex(name);
        return this.getType(index);
    }

    public String getValue(String name) {
        int index = this.getIndex(name);
        return this.getValue(index);
    }

    private int findByName(String uri, String localName) {
        if (this.namePool == null) {
            return -1;
        }
        int f = this.namePool.getFingerprint(uri, localName);
        if (f == -1) {
            return -1;
        }
        return this.findByFingerprint(f);
    }

    private int findByFingerprint(int fingerprint) {
        if (this.codes == null) {
            return -1;
        }
        for (int i = 0; i < this.used; ++i) {
            if (fingerprint != (this.codes[i * 4] & 0xFFFFF)) continue;
            return i;
        }
        return -1;
    }

    public boolean isId(int index) {
        return this.getType(index).equals("ID") || (this.getNameCode(index) & 0xFFFFF) == 388;
    }

    public boolean isIdref(int index) {
        return false;
    }
}

