/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.io.StringWriter;
import java.util.Properties;
import javax.xml.transform.stream.StreamResult;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMinor;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.functions.XSLTFunction;
import net.sf.saxon.instruct.ResultDocument;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.InscopeNamespaceResolver;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NameChecker;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.style.ExpressionContext;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Whitespace;

public class Serialize
extends SystemFunction
implements XSLTFunction {
    Properties outputProperties;
    private transient boolean checked = false;

    public void checkArguments(ExpressionVisitor visitor) throws XPathException {
        if (this.checked) {
            return;
        }
        this.checked = true;
        super.checkArguments(visitor);
        if (this.argument[1] instanceof StringLiteral) {
            StaticContext env = visitor.getStaticContext();
            if (env instanceof ExpressionContext) {
                String formatString = ((StringLiteral)this.argument[1]).getStringValue();
                StructuredQName formatQName = null;
                if (formatString.length() != 0) {
                    formatQName = ((ExpressionContext)env).getStructuredQName(formatString, false);
                }
                this.outputProperties = ((ExpressionContext)env).getXSLStylesheet().gatherOutputProperties(formatQName);
            } else {
                this.outputProperties = new Properties();
                this.outputProperties.setProperty("method", ((StringLiteral)this.argument[1]).getStringValue());
            }
        }
    }

    public Item evaluateItem(XPathContext c) throws XPathException {
        NodeInfo node = (NodeInfo)this.argument[0].evaluateItem(c);
        if (node == null) {
            return StringValue.EMPTY_STRING;
        }
        Properties props = this.outputProperties;
        if (props == null) {
            Item secondArg = this.argument[1].evaluateItem(c);
            if (!(secondArg instanceof NodeInfo) || ((NodeInfo)secondArg).getNodeKind() != 1 || ((NodeInfo)secondArg).getFingerprint() != 165) {
                XPathException err = new XPathException("The second argument of saxon:serialize must either be a string literal, or an xsl:output element");
                err.setXPathContext(c);
                throw err;
            }
            props = new Properties();
            Serialize.processXslOutputElement((NodeInfo)secondArg, props, c);
        }
        try {
            StringWriter result = new StringWriter();
            XPathContextMinor c2 = c.newMinorContext();
            c.setOriginatingConstructType(2053);
            c2.changeOutputDestination(props, new StreamResult(result), false, this.getHostLanguage(), 3, null);
            SequenceReceiver out = c2.getReceiver();
            out.open();
            node.copy(out, 2, true, this.locationId);
            out.close();
            return new StringValue(result.toString());
        }
        catch (XPathException err) {
            throw new XPathException(err);
        }
    }

    public static void processXslOutputElement(NodeInfo element, Properties props, XPathContext c) throws XPathException {
        NodeInfo att;
        AxisIterator iter = element.iterateAxis((byte)2);
        NameChecker nc = c.getConfiguration().getNameChecker();
        InscopeNamespaceResolver resolver = new InscopeNamespaceResolver(element);
        while ((att = (NodeInfo)iter.next()) != null) {
            String uri = att.getURI();
            String local = att.getLocalPart();
            String val = Whitespace.trim(att.getStringValueCS());
            ResultDocument.setSerializationProperty(props, uri, local, val, resolver, false, nc);
        }
    }
}

