/* Created by staff of the U.S. Securities and Exchange Commission.
 * Data and content created by government employees within the scope of their employment
 * are not subject to domestic copyright protection. 17 U.S.C. 105.
 */

import { UserFiltersState } from "./state";
import { callFilter } from "../flex-search/search-worker-interface";

export const UserFiltersMoreFiltersAxes = {

    clickEvent: (input: string) => {
        const tempSet = new Set(UserFiltersState.getAxes);
        if (tempSet.has(input)) {
            (document.getElementById('user-filters-axis')?.querySelector(`[name='${input}']`) as HTMLInputElement).checked = false;
            tempSet.delete(input)
        } else {
            (document.getElementById('user-filters-axis')?.querySelector(`[name='${input}']`) as HTMLInputElement).checked = true;
            tempSet.add(input);
        }
        UserFiltersState.getAxes = [...tempSet];
        callFilter();

    },

    parentClick: (input: Array<{ type: string, value: string }>, element: HTMLInputElement) => {
        const addIfTrue = element.checked;
        const tempSet = new Set(UserFiltersState.getAxes);
        input.forEach((current) => {
            if (addIfTrue) {
                tempSet.add(current.value);
                (document.getElementById('user-filters-axis')?.querySelector(`[name='${current.value}']`) as HTMLInputElement).checked = true;
            } else {
                tempSet.delete(current.value);
                (document.getElementById('user-filters-axis')?.querySelector(`[name='${current.value}']`) as HTMLInputElement).checked = false;
            }
        });
        UserFiltersState.getAxes = [...tempSet];
        callFilter();
    },
};
