/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.om;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.NodeInfo;

public final class DocumentPool
implements Serializable {
    private HashMap documentNameMap = new HashMap(10);

    public void add(DocumentInfo doc, String uri) {
        if (uri != null) {
            this.documentNameMap.put(uri, doc);
        }
    }

    public DocumentInfo find(String uri) {
        return (DocumentInfo)this.documentNameMap.get(uri);
    }

    public String getDocumentURI(NodeInfo doc) {
        Iterator iter = this.documentNameMap.keySet().iterator();
        while (iter.hasNext()) {
            String uri = (String)iter.next();
            if (!this.find(uri).isSameNodeInfo(doc)) continue;
            return uri;
        }
        return null;
    }

    public DocumentInfo discard(DocumentInfo doc) {
        Iterator iter = this.documentNameMap.keySet().iterator();
        while (iter.hasNext()) {
            Object name = iter.next();
            DocumentInfo entry = (DocumentInfo)this.documentNameMap.get(name);
            if (entry != doc) continue;
            this.documentNameMap.remove(name);
            return doc;
        }
        return doc;
    }
}

