/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.util.HashMap;
import java.util.Iterator;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.UserFunctionCall;
import net.sf.saxon.functions.FunctionLibrary;
import net.sf.saxon.instruct.UserFunction;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.XPathException;

public class ExecutableFunctionLibrary
implements FunctionLibrary {
    private Configuration config;
    private HashMap functions = new HashMap(20);

    public ExecutableFunctionLibrary(Configuration config) {
        this.config = config;
    }

    private String makeKey(StructuredQName functionName, int arity) {
        String uri = functionName.getNamespaceURI();
        String local = functionName.getLocalName();
        FastStringBuffer sb = new FastStringBuffer(uri.length() + local.length() + 8);
        sb.append('{');
        sb.append(uri);
        sb.append('}');
        sb.append(local);
        sb.append("/" + arity);
        return sb.toString();
    }

    public void addFunction(UserFunction fn) {
        this.functions.put(this.makeKey(fn.getFunctionName(), fn.getNumberOfArguments()), fn);
    }

    public boolean isAvailable(StructuredQName functionName, int arity) {
        if (arity == -1) {
            for (int i = 0; i <= 20; ++i) {
                if (!this.isAvailable(functionName, i)) continue;
                return true;
            }
            return false;
        }
        return this.functions.get(this.makeKey(functionName, arity)) != null;
    }

    public Expression bind(StructuredQName functionName, Expression[] staticArgs, StaticContext env) throws XPathException {
        UserFunction fn = (UserFunction)this.functions.get(this.makeKey(functionName, staticArgs.length));
        if (fn == null) {
            return null;
        }
        ExpressionVisitor visitor = ExpressionVisitor.make(env);
        UserFunctionCall fc = new UserFunctionCall();
        fc.setFunctionName(functionName);
        fc.setArguments(staticArgs);
        fc.setFunction(fn);
        fc.checkFunctionCall(fn, visitor);
        fc.setStaticType(fn.getResultType(this.config.getTypeHierarchy()));
        return fc;
    }

    public FunctionLibrary copy() {
        ExecutableFunctionLibrary efl = new ExecutableFunctionLibrary(this.config);
        efl.functions = new HashMap(this.functions);
        return efl;
    }

    public Iterator iterateFunctions() {
        return this.functions.values().iterator();
    }
}

