/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.sxpath;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.transform.Source;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.instruct.SlotManager;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.sxpath.XPathDynamicContext;
import net.sf.saxon.sxpath.XPathEvaluator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.Value;

public class XPathExpression {
    private XPathEvaluator evaluator;
    private Expression expression;
    private SlotManager stackFrameMap;
    private int numberOfExternalVariables;

    protected XPathExpression(XPathEvaluator evaluator, Expression exp) {
        this.expression = exp;
        this.evaluator = evaluator;
    }

    protected void setStackFrameMap(SlotManager map, int numberOfExternalVariables) {
        this.stackFrameMap = map;
        this.numberOfExternalVariables = numberOfExternalVariables;
    }

    public XPathDynamicContext createDynamicContext(Item contextItem) {
        XPathContextMajor context = new XPathContextMajor(contextItem, this.evaluator.getExecutable());
        context.openStackFrame(this.stackFrameMap);
        return new XPathDynamicContext(context);
    }

    public SequenceIterator iterate(XPathDynamicContext context) throws XPathException {
        context.checkExternalVariables(this.stackFrameMap, this.numberOfExternalVariables);
        return this.expression.iterate(context.getXPathContextObject());
    }

    public List evaluate(XPathDynamicContext context) throws XPathException {
        Item item;
        SequenceIterator iter = this.expression.iterate(context.getXPathContextObject());
        ArrayList<Item> list = new ArrayList<Item>(20);
        while ((item = iter.next()) != null) {
            list.add(item);
        }
        return list;
    }

    public Item evaluateSingle(XPathDynamicContext context) throws XPathException {
        return this.expression.iterate(context.getXPathContextObject()).next();
    }

    public List evaluate(Source source) throws XPathException {
        NodeInfo origin = source instanceof NodeInfo ? (NodeInfo)source : this.evaluator.getConfiguration().buildDocument(source);
        XPathDynamicContext dynamicContext = this.createDynamicContext(origin);
        SequenceIterator iter = this.iterate(dynamicContext);
        SequenceExtent extent = new SequenceExtent(iter);
        List result = (List)extent.convertToJava(List.class, dynamicContext.getXPathContextObject());
        if (result == null) {
            result = Collections.EMPTY_LIST;
        }
        return result;
    }

    public Object evaluateSingle(Source source) throws XPathException {
        NodeInfo origin = source instanceof NodeInfo ? (NodeInfo)source : this.evaluator.getConfiguration().buildDocument(source);
        XPathDynamicContext context = this.createDynamicContext(origin);
        SequenceIterator iterator = this.iterate(context);
        Item item = iterator.next();
        if (item == null) {
            return null;
        }
        return Value.convertToJava(item);
    }

    public SequenceIterator rawIterator(Source source) throws XPathException {
        NodeInfo origin = source instanceof NodeInfo ? (NodeInfo)source : this.evaluator.getConfiguration().buildDocument(source);
        XPathDynamicContext context = this.createDynamicContext(origin);
        return this.iterate(context);
    }

    public Expression getInternalExpression() {
        return this.expression;
    }
}

