/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree;

import java.util.Iterator;
import net.sf.saxon.event.LocationCopier;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.AttributeCollectionImpl;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceCodeIterator;
import net.sf.saxon.om.NamespaceException;
import net.sf.saxon.om.NamespaceIterator;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.sort.IntArraySet;
import net.sf.saxon.sort.IntIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.DocumentImpl;
import net.sf.saxon.tree.ElementImpl;
import net.sf.saxon.tree.NodeImpl;
import net.sf.saxon.tree.ParentNodeImpl;

public class ElementWithAttributes
extends ElementImpl
implements NamespaceResolver {
    protected AttributeCollection attributeList;
    protected int[] namespaceList = null;

    public void initialise(int nameCode, AttributeCollectionImpl atts, NodeInfo parent, String baseURI, int lineNumber, int sequenceNumber) {
        this.nameCode = nameCode;
        this.attributeList = atts;
        this.parent = (ParentNodeImpl)parent;
        this.sequence = sequenceNumber;
        this.root = (DocumentImpl)parent.getDocumentRoot();
        this.root.setLineNumber(sequenceNumber, lineNumber);
        this.root.setSystemId(sequenceNumber, baseURI);
    }

    public void setNamespaceDeclarations(int[] namespaces, int namespacesUsed) {
        this.namespaceList = new int[namespacesUsed];
        System.arraycopy(namespaces, 0, this.namespaceList, 0, namespacesUsed);
    }

    public String getURIForPrefix(String prefix, boolean useDefault) {
        if (prefix.equals("xml")) {
            return "http://www.w3.org/XML/1998/namespace";
        }
        if (prefix.length() == 0 && !useDefault) {
            return "";
        }
        NamePool pool = this.getNamePool();
        short prefixCode = pool.getCodeForPrefix(prefix);
        if (prefixCode == -1) {
            return null;
        }
        try {
            short uriCode = this.getURICodeForPrefixCode(prefixCode);
            return pool.getURIFromURICode(uriCode);
        }
        catch (NamespaceException e) {
            return null;
        }
    }

    public Iterator iteratePrefixes() {
        return new Iterator(){
            private NamePool pool = null;
            private IntIterator iter = NamespaceCodeIterator.iterateNamespaces(ElementWithAttributes.this);

            public boolean hasNext() {
                return this.pool == null || this.iter.hasNext();
            }

            public Object next() {
                if (this.pool == null) {
                    this.pool = ElementWithAttributes.this.getNamePool();
                    return "xml";
                }
                return this.pool.getPrefixFromNamespaceCode(this.iter.next());
            }

            public void remove() {
                throw new UnsupportedOperationException("remove");
            }
        };
    }

    public short getURICodeForPrefix(String prefix) throws NamespaceException {
        if (prefix.equals("xml")) {
            return 1;
        }
        NamePool pool = this.getNamePool();
        short prefixCode = pool.getCodeForPrefix(prefix);
        if (prefixCode == -1) {
            throw new NamespaceException(prefix);
        }
        return this.getURICodeForPrefixCode(prefixCode);
    }

    private short getURICodeForPrefixCode(int prefixCode) throws NamespaceException {
        if (this.namespaceList != null) {
            for (int i = 0; i < this.namespaceList.length; ++i) {
                if (this.namespaceList[i] >> 16 != prefixCode) continue;
                return (short)(this.namespaceList[i] & 0xFFFF);
            }
        }
        NodeInfo next = this.parent;
        while (true) {
            if (next.getNodeKind() == 9) {
                if (prefixCode == 0) {
                    return 0;
                }
                throw new NamespaceException(this.getNamePool().getPrefixFromNamespaceCode(prefixCode << 16));
            }
            if (next instanceof ElementWithAttributes) {
                return ((ElementWithAttributes)next).getURICodeForPrefixCode(prefixCode);
            }
            next = next.getParent();
        }
    }

    public String getPrefixForURI(String uri) {
        if (uri.equals("http://www.w3.org/XML/1998/namespace")) {
            return "xml";
        }
        NamePool pool = this.getNamePool();
        short uriCode = pool.getCodeForURI(uri);
        if (uriCode < 0) {
            return null;
        }
        return this.getPrefixForURICode(uriCode);
    }

    private String getPrefixForURICode(int code) {
        if (this.namespaceList != null) {
            for (int i = 0; i < this.namespaceList.length; ++i) {
                if ((this.namespaceList[i] & 0xFFFF) != code) continue;
                return this.getNamePool().getPrefixFromNamespaceCode(this.namespaceList[i]);
            }
        }
        NodeInfo next = this.parent;
        while (!(next instanceof DocumentInfo)) {
            if (next instanceof ElementWithAttributes) {
                return ((ElementWithAttributes)next).getPrefixForURICode(code);
            }
            next = next.getParent();
        }
        return null;
    }

    public int[] getDeclaredNamespaces(int[] buffer) {
        return this.namespaceList == null ? IntArraySet.EMPTY_INT_ARRAY : this.namespaceList;
    }

    public int[] getInScopeNamespaceCodes() {
        return NamespaceIterator.getInScopeNamespaceCodes(this);
    }

    public AttributeCollection getAttributeList() {
        return this.attributeList;
    }

    public String getAttributeValue(int fingerprint) {
        return this.attributeList.getValueByFingerprint(fingerprint);
    }

    public void copy(Receiver out, int whichNamespaces, boolean copyAnnotations, int locationId) throws XPathException {
        int typeCode;
        int n = typeCode = copyAnnotations ? this.getTypeAnnotation() : -1;
        if (locationId == 0 && out instanceof LocationCopier) {
            out.setSystemId(this.getBaseURI());
            ((LocationCopier)out).setLineNumber(this.getLineNumber());
        }
        out.startElement(this.getNameCode(), typeCode, locationId, 0);
        switch (whichNamespaces) {
            case 0: {
                break;
            }
            case 1: {
                int ns;
                int[] localNamespaces = this.getDeclaredNamespaces(null);
                for (int i = 0; i < localNamespaces.length && (ns = localNamespaces[i]) != -1; ++i) {
                    out.namespace(ns, 0);
                }
                break;
            }
            case 2: {
                NamespaceCodeIterator.sendNamespaces(this, out);
            }
        }
        for (int i = 0; i < this.attributeList.getLength(); ++i) {
            out.attribute(this.attributeList.getNameCode(i), 631, this.attributeList.getValue(i), 0, 0);
        }
        out.startContent();
        int childNamespaces = whichNamespaces == 0 ? 0 : 1;
        for (NodeImpl next = (NodeImpl)this.getFirstChild(); next != null; next = (NodeImpl)next.getNextSibling()) {
            next.copy(out, childNamespaces, copyAnnotations, locationId);
        }
        out.endElement();
    }
}

