/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.sxpath;

import javax.xml.transform.Source;
import net.sf.saxon.expr.TypeChecker;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.instruct.SlotManager;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SingletonIterator;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.om.UnfailingIterator;
import net.sf.saxon.om.ValueRepresentation;
import net.sf.saxon.sxpath.XPathVariable;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.Value;

public class XPathDynamicContext {
    private XPathContextMajor contextObject;

    protected XPathDynamicContext(XPathContextMajor contextObject) {
        this.contextObject = contextObject;
    }

    public void setContextNode(Source source) throws XPathException {
        NodeInfo origin;
        if (source instanceof NodeInfo) {
            origin = (NodeInfo)source;
            if (!origin.getConfiguration().isCompatible(this.contextObject.getConfiguration())) {
                throw new XPathException("Supplied node must be built using the same or a compatible Configuration", "SXXP0004");
            }
        } else {
            origin = this.contextObject.getConfiguration().buildDocument(source);
        }
        this.setContextItem(origin);
    }

    public void setContextItem(Item item) throws XPathException {
        if (item instanceof NodeInfo && !((NodeInfo)item).getConfiguration().isCompatible(this.contextObject.getConfiguration())) {
            throw new XPathException("Supplied node must be built using the same or a compatible Configuration", "SXXP0004");
        }
        UnfailingIterator iter = SingletonIterator.makeIterator(item);
        iter.next();
        this.contextObject.setCurrentIterator(iter);
    }

    public Item getContextItem() {
        return this.contextObject.getContextItem();
    }

    public void setVariable(XPathVariable variable, ValueRepresentation value) throws XPathException {
        Item item;
        XPathException err;
        SequenceType requiredType = variable.getRequiredType();
        if (requiredType != SequenceType.ANY_SEQUENCE && (err = TypeChecker.testConformance(value, requiredType, this.contextObject)) != null) {
            throw err;
        }
        SequenceIterator iter = Value.asIterator(value);
        while ((item = iter.next()) != null) {
            if (!(item instanceof NodeInfo) || ((NodeInfo)item).getConfiguration().isCompatible(this.contextObject.getConfiguration())) continue;
            throw new XPathException("Supplied node must be built using the same or a compatible Configuration", "SXXP0004");
        }
        this.contextObject.setLocalVariable(variable.getLocalSlotNumber(), value);
    }

    protected XPathContext getXPathContextObject() {
        return this.contextObject;
    }

    protected void checkExternalVariables(SlotManager stackFrameMap, int numberOfExternals) throws XPathException {
        ValueRepresentation[] stack = this.contextObject.getStackFrame().getStackFrameValues();
        for (int i = 0; i < numberOfExternals; ++i) {
            if (stack[i] != null) continue;
            StructuredQName qname = (StructuredQName)stackFrameMap.getVariableMap().get(i);
            throw new XPathException("No value has been supplied for variable $" + qname.getDisplayName());
        }
    }
}

