/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.sort;

import java.io.Serializable;
import java.util.Arrays;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.sort.IntHashSet;
import net.sf.saxon.sort.IntIterator;
import net.sf.saxon.sort.IntSet;

public class IntArraySet
implements Serializable,
IntSet {
    public static final int[] EMPTY_INT_ARRAY = new int[0];
    private int[] contents;
    private int hashCode = -1;

    public IntArraySet() {
        this.contents = EMPTY_INT_ARRAY;
    }

    public IntArraySet(IntHashSet input) {
        this.contents = input.getValues();
        Arrays.sort(this.contents);
    }

    public IntArraySet(IntArraySet input) {
        this.contents = new int[input.contents.length];
        System.arraycopy(input.contents, 0, this.contents, 0, this.contents.length);
    }

    public void clear() {
        this.contents = EMPTY_INT_ARRAY;
        this.hashCode = -1;
    }

    public int size() {
        return this.contents.length;
    }

    public boolean isEmpty() {
        return this.contents.length == 0;
    }

    public int[] getValues() {
        return this.contents;
    }

    public boolean contains(int value) {
        return Arrays.binarySearch(this.contents, value) >= 0;
    }

    public boolean remove(int value) {
        this.hashCode = -1;
        int pos = Arrays.binarySearch(this.contents, value);
        if (pos < 0) {
            return false;
        }
        int[] newArray = new int[this.contents.length - 1];
        if (pos > 0) {
            System.arraycopy(this.contents, 0, newArray, 0, pos);
        }
        if (pos < newArray.length) {
            System.arraycopy(this.contents, pos + 1, newArray, pos, this.contents.length - pos);
        }
        this.contents = newArray;
        return true;
    }

    public boolean add(int value) {
        this.hashCode = -1;
        if (this.contents.length == 0) {
            this.contents = new int[]{value};
            return true;
        }
        int pos = Arrays.binarySearch(this.contents, value);
        if (pos >= 0) {
            return false;
        }
        pos = -pos - 1;
        int[] newArray = new int[this.contents.length + 1];
        if (pos > 0) {
            System.arraycopy(this.contents, 0, newArray, 0, pos);
        }
        newArray[pos] = value;
        if (pos < this.contents.length) {
            System.arraycopy(this.contents, pos, newArray, pos + 1, newArray.length - pos);
        }
        this.contents = newArray;
        return true;
    }

    public int getFirst() {
        return this.contents[0];
    }

    public IntIterator iterator() {
        return new IntArraySetIterator();
    }

    public IntArraySet union(IntArraySet other) {
        if (this.size() == 0) {
            return new IntArraySet(other);
        }
        if (other.isEmpty()) {
            return new IntArraySet(this);
        }
        if (this.equals(other)) {
            return this;
        }
        int[] merged = new int[this.size() + other.size()];
        int[] a = this.contents;
        int[] b = other.contents;
        int m = a.length;
        int n = b.length;
        int o = 0;
        int i = 0;
        int j = 0;
        do {
            if (a[i] < b[j]) {
                merged[o++] = a[i++];
            } else if (b[j] < a[i]) {
                merged[o++] = b[j++];
            } else {
                merged[o++] = a[i++];
                ++j;
            }
            if (i != m) continue;
            System.arraycopy(b, j, merged, o, n - j);
            return IntArraySet.make(merged, o += n - j);
        } while (j != n);
        System.arraycopy(a, i, merged, o, m - i);
        return IntArraySet.make(merged, o += m - i);
    }

    public static IntArraySet make(int[] in, int size) {
        int[] out;
        if (in.length == size) {
            out = in;
        } else {
            out = new int[size];
            System.arraycopy(in, 0, out, 0, size);
        }
        return new IntArraySet(out);
    }

    private IntArraySet(int[] content) {
        this.contents = content;
    }

    public String toString() {
        FastStringBuffer sb = new FastStringBuffer(this.contents.length * 4);
        for (int i = 0; i < this.contents.length; ++i) {
            if (i == this.contents.length - 1) {
                sb.append(this.contents[i] + "");
                continue;
            }
            if (this.contents[i] + 1 != this.contents[i + 1]) {
                sb.append(this.contents[i] + ",");
                continue;
            }
            int j = i + 1;
            while (this.contents[j] == this.contents[j - 1] + 1 && ++j != this.contents.length) {
            }
            sb.append(this.contents[i] + "-" + this.contents[j - 1] + ",");
            i = j;
        }
        return sb.toString();
    }

    public boolean equals(Object other) {
        if (other instanceof IntArraySet) {
            IntArraySet s = (IntArraySet)other;
            return this.hashCode() == other.hashCode() && Arrays.equals(this.contents, s.contents);
        }
        return other instanceof IntSet && this.contents.length == ((IntSet)other).size() && this.containsAll((IntSet)other);
    }

    public int hashCode() {
        if (this.hashCode == -1) {
            int h = 936247625;
            IntIterator it = this.iterator();
            while (it.hasNext()) {
                h += it.next();
            }
            this.hashCode = h;
        }
        return this.hashCode;
    }

    public boolean containsAll(IntSet other) {
        IntIterator it = other.iterator();
        while (it.hasNext()) {
            if (this.contains(it.next())) continue;
            return false;
        }
        return true;
    }

    private class IntArraySetIterator
    implements IntIterator,
    Serializable {
        private int i = 0;

        public boolean hasNext() {
            return this.i < IntArraySet.this.contents.length;
        }

        public int next() {
            return IntArraySet.this.contents[this.i++];
        }
    }
}

